/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.DefaultComponentSelector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.i18n.BundleFactory;
import org.apache.cocoon.i18n.XMLResourceBundle;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXParseException;

public class XMLResourceBundleFactory
extends DefaultComponentSelector
implements BundleFactory,
Serviceable,
Configurable,
Disposable,
ThreadSafe,
LogEnabled {
    protected boolean cacheAtStartup;
    protected String directory;
    protected final Map cacheNotFound = new HashMap();
    private Logger logger;
    protected ServiceManager manager = null;
    protected SourceResolver resolver;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        Iterator i = this.getComponentMap().values().iterator();
        while (i.hasNext()) {
            Object bundle = i.next();
            if (bundle instanceof Disposable) {
                ((Disposable)bundle).dispose();
            }
            i.remove();
        }
        this.manager.release((Object)this.resolver);
        this.manager = null;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.cacheAtStartup = configuration.getChild("cache-at-startup").getValueAsBoolean(false);
        try {
            this.directory = configuration.getChild("catalogue-location", true).getValue();
        }
        catch (ConfigurationException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Root directory not provided in configuration, using default (root).");
            }
            this.directory = "";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configured with: cacheAtStartup = " + this.cacheAtStartup + ", directory = '" + this.directory + "'");
        }
    }

    protected String getDirectory() {
        return this.directory;
    }

    protected boolean cacheAtStartup() {
        return this.cacheAtStartup;
    }

    public Bundle select(String name, String locale) throws ComponentException {
        return this.select(this.getDirectory(), name, locale);
    }

    public Bundle select(String name, Locale locale) throws ComponentException {
        return this.select(this.getDirectory(), name, locale);
    }

    public Bundle select(String directory, String name, String localeName) throws ComponentException {
        return this.select(directory, name, new Locale(localeName, localeName));
    }

    public Bundle select(String directory, String name, Locale locale) throws ComponentException {
        String[] directories = new String[]{directory};
        return this.select(directories, name, locale);
    }

    public Bundle select(String[] directories, String name, Locale locale) throws ComponentException {
        XMLResourceBundle bundle = this._select(directories, 0, name, locale);
        if (bundle == null) {
            throw new ComponentException(name, "Unable to locate resource: " + name);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLResourceBundle _select(String[] directories, int index, String name, Locale locale) {
        String fileName;
        XMLResourceBundle bundle;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("selecting from: " + name + ", locale: " + locale + ", directory: " + directories[index]);
        }
        if ((bundle = this.selectCached(fileName = this.getFileName(directories[index], name, locale))) == null) {
            XMLResourceBundleFactory xMLResourceBundleFactory = this;
            synchronized (xMLResourceBundleFactory) {
                bundle = this.selectCached(fileName);
                if (bundle == null) {
                    XMLResourceBundle parentBundle = null;
                    if (locale != null && !locale.getLanguage().equals("")) {
                        parentBundle = ++index == directories.length ? this._select(directories, 0, name, this.getParentLocale(locale)) : this._select(directories, index, name, locale);
                    } else if (++index < directories.length) {
                        parentBundle = this._select(directories, index, name, locale);
                    }
                    if (!this.isNotFoundBundle(fileName)) {
                        bundle = this._loadBundle(name, fileName, locale, parentBundle);
                        this.updateCache(fileName, bundle);
                    }
                    if (bundle == null) {
                        return parentBundle;
                    }
                }
            }
        }
        return bundle;
    }

    private XMLResourceBundle _loadBundle(String name, String fileName, Locale locale, XMLResourceBundle parentBundle) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Loading bundle: " + name + ", locale: " + locale + ", uri: " + fileName);
        }
        XMLResourceBundle bundle = null;
        try {
            bundle = new XMLResourceBundle();
            bundle.enableLogging(this.logger);
            bundle.service(this.manager);
            bundle.init(name, fileName, locale, parentBundle);
            return bundle;
        }
        catch (ResourceNotFoundException e) {
            this.getLogger().info("Resource not found: " + name + ", locale: " + locale + ", bundleName: " + fileName + ". Exception: " + e.toString());
        }
        catch (SourceNotFoundException e) {
            this.getLogger().info("Resource not found: " + name + ", locale: " + locale + ", bundleName: " + fileName + ". Exception: " + e.toString());
        }
        catch (SAXParseException e) {
            this.getLogger().error("Incorrect resource format", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error("Resource loading failed", (Throwable)e);
        }
        return null;
    }

    public void release(Component component) {
    }

    protected Locale getParentLocale(Locale locale) {
        Locale newloc = locale.getVariant().equals("") ? (locale.getCountry().equals("") ? new Locale("", "", "") : new Locale(locale.getLanguage(), "", "")) : new Locale(locale.getLanguage(), locale.getCountry(), "");
        return newloc;
    }

    protected String getFileName(String base, String name, Locale locale) {
        StringBuffer sb = new StringBuffer();
        if (base != null && base.length() != 0) {
            try {
                Source src = this.resolver.resolveURI(base);
                String uri = src.getURI();
                sb.append(uri);
                if (!uri.endsWith("/")) {
                    sb.append('/');
                }
                this.resolver.release(src);
            }
            catch (IOException ioe) {
                throw new CascadingRuntimeException("Cannot resolve " + base, (Throwable)ioe);
            }
        }
        sb.append(name);
        if (locale != null) {
            if (!locale.getLanguage().equals("")) {
                sb.append("_");
                sb.append(locale.getLanguage());
            }
            if (!locale.getCountry().equals("")) {
                sb.append("_");
                sb.append(locale.getCountry());
            }
            if (!locale.getVariant().equals("")) {
                sb.append("_");
                sb.append(locale.getVariant());
            }
        }
        sb.append(".xml");
        String result = sb.toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolved bundle name: " + name + ", locale: " + locale + " --> " + result);
        }
        return result;
    }

    protected XMLResourceBundle selectCached(String fileName) {
        XMLResourceBundle bundle;
        block3: {
            bundle = null;
            try {
                bundle = (XMLResourceBundle)super.select((Object)fileName);
                bundle.update(fileName);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Returning from cache: " + fileName);
                }
            }
            catch (ComponentException e) {
                if (!this.getLogger().isDebugEnabled()) break block3;
                this.getLogger().debug("Not found in cache: " + fileName);
            }
        }
        return bundle;
    }

    protected boolean isNotFoundBundle(String fileName) {
        String result = (String)this.cacheNotFound.get(fileName);
        if (result != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Returning from not_found_cache: " + fileName);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Not found in not_found_cache: " + fileName);
        }
        return result != null;
    }

    protected void updateCache(String fileName, XMLResourceBundle bundle) {
        if (bundle == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Updating not_found_cache: " + fileName);
            }
            this.cacheNotFound.put(fileName, fileName);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Updating cache: " + fileName);
            }
            super.put((Object)fileName, (Component)bundle);
        }
    }
}

