/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.regexp.RE;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JPathTransformer
extends AbstractSAXTransformer
implements Initializable {
    public static final String JPATH_NAMESPACE_URI = "http://apache.org/xsp/jpath/1.0";
    public static final String JPATH_ACTION = "jpath:action";
    public static final String JPATH_VALUEOF = "value-of";
    public static final String JPATH_VALUEOF_SELECT = "select";
    public static final String JPATH_CONTINUATION = "continuation";
    public static final String JPATH_CONTINUATION_SELECT = "select";
    public static final String JPATH_IF = "if";
    public static final String JPATH_TEST = "test";
    private WebContinuation m_kont;
    private RE m_re;
    private JXPathContext m_jxpathContext;
    private Map m_cache;

    public void initialize() throws Exception {
        this.namespaceURI = JPATH_NAMESPACE_URI;
        this.m_re = new RE("id");
        this.m_cache = new HashMap();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        Object bean = FlowHelper.getContextObject(objectModel);
        this.m_kont = FlowHelper.getWebContinuation(objectModel);
        this.m_jxpathContext = JXPathContext.newContext((Object)bean);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        AttributesImpl impl = new AttributesImpl(a);
        this.checkJPathAction(impl);
        super.startElement(uri, loc, raw, impl);
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (JPATH_VALUEOF.equals(name)) {
            this.doValueOf(attr);
        } else if (JPATH_CONTINUATION.equals(name)) {
            this.doContinuation(attr);
        } else if (JPATH_IF.equals(name)) {
            this.doIf(attr);
        } else {
            super.startTransformingElement(uri, name, raw, attr);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (JPATH_VALUEOF.equals(name) || JPATH_CONTINUATION.equals(name)) {
            return;
        }
        if (JPATH_IF.equals(name)) {
            this.finishIf();
        } else {
            super.endTransformingElement(uri, name, raw);
        }
    }

    private void checkJPathAction(AttributesImpl a) {
        int idx = a.getIndex(JPATH_ACTION);
        if (idx != -1 && JPATH_NAMESPACE_URI.equals(a.getURI(idx))) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("found jpath:action, adjusting");
            }
            String value = a.getValue(idx);
            String id = this.m_kont.getContinuation(0).getId();
            a.removeAttribute(idx);
            a.addAttribute("", "action", "action", "CDATA", this.m_re.subst(value, id));
        }
    }

    private Object getValue(String variable) {
        Object value;
        if (this.m_cache.containsKey(variable)) {
            value = this.m_cache.get(variable);
        } else {
            value = JXPathContext.compile((String)variable).getValue(this.m_jxpathContext);
            if (value == null && this.getLogger().isWarnEnabled()) {
                String msg = "Value for jpath variable '" + variable + "' does not exist";
                this.getLogger().warn(msg);
            }
            this.m_cache.put(variable, value);
        }
        return value;
    }

    private void doValueOf(Attributes a) throws SAXException, ProcessingException {
        String select = a.getValue("select");
        if (null == select) {
            throw new ProcessingException("jpath:value-of specified without a select attribute");
        }
        this.sendTextEvent((String)this.getValue(select));
    }

    private void doContinuation(Attributes a) throws SAXException {
        String level = a.getValue("select");
        String id = level != null ? this.m_kont.getContinuation(Integer.decode(level)).getId() : this.m_kont.getContinuation(0).getId();
        this.sendTextEvent(id);
    }

    private void doIf(Attributes a) throws SAXException {
        boolean isNonNullNonBoolean;
        if (this.ignoreEventsCount > 0) {
            ++this.ignoreEventsCount;
            return;
        }
        Object value = this.getValue(a.getValue(JPATH_TEST));
        boolean isTrueBoolean = value instanceof Boolean && (Boolean)value == true;
        boolean bl = isNonNullNonBoolean = value != null && !(value instanceof Boolean);
        if (isTrueBoolean || isNonNullNonBoolean) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("jpath:if results in allowing subelements");
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("jpath:if results in disallowing subelements");
            }
            ++this.ignoreEventsCount;
        }
    }

    private void finishIf() throws SAXException {
        if (this.ignoreEventsCount > 0) {
            --this.ignoreEventsCount;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("jpath:if closed");
        }
    }

    public void recycle() {
        super.recycle();
        this.m_cache.clear();
        this.m_kont = null;
        this.m_jxpathContext = null;
    }
}

