/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.portal.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.webapps.portal.components.PortalManager;
import org.apache.cocoon.webapps.portal.components.PortalManagerImpl;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SessionContextImpl
implements SessionContext {
    public static ThreadLocal copletInfo = new ThreadLocal();
    private String name;
    private Map attributes = new HashMap();
    private Document layoutDOM;
    private Document configurationDOM;
    private Map profile;
    private SourceParameters copletPars;
    private Element statusProfile;
    private String copletID;
    private String copletNumber;
    private String profileID;
    private String portalURI;
    private String mediaType;
    private Request request;
    private XPathProcessor xpathProcessor;

    public SessionContextImpl(String name, Map objectModel, PortalManager portal, XPathProcessor xpathProcessor) throws IOException, SAXException, ProcessingException {
        this.xpathProcessor = xpathProcessor;
        this.setup(name, null, null);
        Map info = (Map)copletInfo.get();
        if (info != null) {
            copletInfo.set(null);
            this.copletPars = (SourceParameters)info.get("COPLETINFO_PARAMETERS");
            this.portalURI = (String)info.get("COPLETINFO_PORTALURI");
            if (this.copletPars != null) {
                this.copletID = this.copletPars.getParameter("id");
                this.copletNumber = this.copletPars.getParameter("number");
                if (this.copletID != null && this.copletNumber != null) {
                    this.portalURI = this.portalURI + (this.portalURI.indexOf(63) == -1 ? (char)'?' : '&') + "portalcmd=update_" + this.copletID + "_" + this.copletNumber;
                }
            }
            this.statusProfile = (Element)info.get("COPLETINFO_STATUSPROFILE");
        }
        this.mediaType = this.copletPars != null ? this.copletPars.getParameter("media") : portal.getMediaType();
        SessionContext context = portal.getContext(false);
        if (context != null && context.getAttribute("role") != null) {
            this.profileID = portal.getProfileID("user", (String)context.getAttribute("role"), (String)context.getAttribute("ID"), false);
            this.profile = portal.retrieveProfile(this.profileID);
        }
        this.getConfigurationDOM(portal);
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
    }

    public String getName() {
        return this.name;
    }

    public Request getRequest() {
        return this.request;
    }

    private void getLayoutDOM() throws ProcessingException {
        if (this.layoutDOM == null && this.profile != null) {
            try {
                Map portalLayouts = (Map)this.profile.get("portalLayouts");
                Map copletLayouts = (Map)this.profile.get("copletLayouts");
                DOMBuilder builder = new DOMBuilder();
                builder.startDocument();
                PortalManagerImpl.streamLayoutProfile((XMLConsumer)builder, portalLayouts, copletLayouts, this.mediaType);
                builder.endDocument();
                this.layoutDOM = builder.getDocument();
            }
            catch (SAXException local) {
                throw new ProcessingException("Unable to get portal." + local, (Throwable)local);
            }
        }
    }

    private void getConfigurationDOM(PortalManager portal) throws ProcessingException, IOException {
        if (this.configurationDOM == null && portal != null) {
            try {
                String contextID = null;
                if (this.copletID != null && this.copletNumber != null) {
                    contextID = "coplet_" + this.copletID + "_" + this.copletNumber;
                }
                DOMBuilder builder = new DOMBuilder();
                builder.startDocument();
                portal.streamConfiguration((XMLConsumer)builder, this.portalURI, this.profileID, this.mediaType, contextID);
                builder.endDocument();
                this.configurationDOM = builder.getDocument();
            }
            catch (SAXException local) {
                throw new ProcessingException("Unable to get portal." + local, (Throwable)local);
            }
        }
    }

    public void setup(String value, String load, String save) {
        this.name = value;
    }

    public synchronized DocumentFragment getXML(String path) throws ProcessingException {
        Document doc;
        DocumentFragment result = null;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        NodeList list = null;
        if (path == null || path.equals("")) {
            doc = DOMUtil.createDocument();
            result = doc.createDocumentFragment();
            this.getLayoutDOM();
            if (this.layoutDOM != null) {
                result.appendChild(doc.importNode(this.layoutDOM.getDocumentElement(), true));
            }
            if (this.configurationDOM != null) {
                result.appendChild(doc.importNode(this.configurationDOM.getDocumentElement(), true));
            }
            if (this.statusProfile != null && this.copletID != null && this.copletNumber != null) {
                String statusPath = "customization/coplet[@id='" + this.copletID + "' and @number='" + this.copletNumber + "']";
                try {
                    Node node = DOMUtil.getSingleNode((Node)this.statusProfile, (String)statusPath, (XPathProcessor)this.xpathProcessor);
                    if (node != null) {
                        Element copletData = doc.createElementNS(null, "coplet-data");
                        NodeList childs = node.getChildNodes();
                        if (childs != null) {
                            int l = 0;
                            while (l < childs.getLength()) {
                                copletData.appendChild(doc.importNode(childs.item(l), true));
                                ++l;
                            }
                        }
                        result.appendChild(copletData);
                    }
                }
                catch (TransformerException localException) {
                    throw new ProcessingException("TransformerException: " + localException, (Throwable)localException);
                }
            }
        }
        if (path.equals("layout") || path.startsWith("layout/")) {
            try {
                this.getLayoutDOM();
                if (this.layoutDOM != null) {
                    list = DOMUtil.selectNodeList((Node)this.layoutDOM, (String)path, (XPathProcessor)this.xpathProcessor);
                }
            }
            catch (TransformerException localException) {
                throw new ProcessingException("TransformerException: " + localException, (Throwable)localException);
            }
        }
        if (path.equals("configuration") || path.startsWith("configuration/")) {
            try {
                if (this.configurationDOM != null) {
                    list = DOMUtil.selectNodeList((Node)this.configurationDOM, (String)path, (XPathProcessor)this.xpathProcessor);
                }
            }
            catch (TransformerException localException) {
                throw new ProcessingException("TransformerException: " + localException, (Throwable)localException);
            }
        }
        if ((path.startsWith("coplet-data/") || path.equals("coplet-data")) && this.statusProfile != null && this.copletID != null && this.copletNumber != null) {
            String statusPath = "customization/coplet[@id='" + this.copletID + "' and @number='" + this.copletNumber + "']";
            if (path.startsWith("coplet-data/")) {
                statusPath = statusPath + path.substring(11);
            }
            try {
                list = DOMUtil.selectNodeList((Node)this.statusProfile, (String)statusPath, (XPathProcessor)this.xpathProcessor);
            }
            catch (TransformerException localException) {
                throw new ProcessingException("TransformerException: " + localException, (Throwable)localException);
            }
        }
        if (list != null && list.getLength() > 0) {
            doc = DOMUtil.createDocument();
            result = doc.createDocumentFragment();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 2) {
                    result.appendChild(doc.createTextNode(list.item(i).getNodeValue()));
                } else {
                    NodeList childs = list.item(i).getChildNodes();
                    if (childs != null) {
                        int m = 0;
                        while (m < childs.getLength()) {
                            result.appendChild(doc.importNode(childs.item(m), true));
                            ++m;
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setXML(String path, DocumentFragment fragment) throws ProcessingException {
        block6: {
            block7: {
                if (path == null) break block6;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (!path.startsWith("coplet-data/") && !path.equals("coplet-data") || this.statusProfile == null || this.copletID == null || this.copletNumber == null) break block6;
                statusPath = "customization/coplet[@id='" + this.copletID + "' and @number='" + this.copletNumber + "']";
                if (path.startsWith("coplet-data/")) {
                    statusPath = statusPath + path.substring(11);
                }
                if ((node = DOMUtil.selectSingleNode((Node)this.statusProfile, (String)statusPath, (XPathProcessor)this.xpathProcessor)).getNodeType() != 2) ** GOTO lbl14
                attr = (Attr)node;
                attr.setNodeValue(DOMUtil.getValueOfNode((Node)fragment));
                break block7;
lbl-1000:
                // 1 sources

                {
                    node.removeChild(node.getFirstChild());
lbl14:
                    // 2 sources

                    ** while (node.hasChildNodes())
                }
lbl15:
                // 1 sources

                childs = fragment.getChildNodes();
                if (childs != null && childs.getLength() > 0) {
                    i = 0;
                    while (i < childs.getLength()) {
                        n = this.statusProfile.getOwnerDocument().importNode(childs.item(i), true);
                        node.appendChild(n);
                        ++i;
                    }
                }
            }
            if (this.copletPars.getParameter("persistent", "false").equals("true")) {
                this.profile.put("saveStatus", "true");
            }
        }
    }

    public synchronized void appendXML(String path, DocumentFragment fragment) throws ProcessingException {
        throw new ProcessingException("appendXML() not implemented.");
    }

    public synchronized void removeXML(String path) throws ProcessingException {
        throw new ProcessingException("removeXML() not implemented.");
    }

    public synchronized Node getSingleNode(String path) throws ProcessingException {
        throw new ProcessingException("getSingleNode() not implemented.");
    }

    public synchronized NodeList getNodeList(String path) throws ProcessingException {
        throw new ProcessingException("getNodeList() not implemented.");
    }

    public synchronized void setNode(String path, Node node) throws ProcessingException {
        throw new ProcessingException("setNode() not implemented.");
    }

    public synchronized void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public synchronized Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public synchronized Object getAttribute(String key, Object defaultObject) {
        Object value = this.attributes.get(key);
        if (value == null) {
            value = defaultObject;
        }
        return value;
    }

    public synchronized String getValueOfNode(String path) throws ProcessingException {
        throw new ProcessingException("getValueOfNode() not implemented.");
    }

    public synchronized void setValueOfNode(String path, String value) throws ProcessingException {
        throw new ProcessingException("setValueOfNode() not implemented.");
    }

    public synchronized boolean streamXML(String path, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, ProcessingException {
        boolean streamed = false;
        DocumentFragment fragment = this.getXML(path);
        if (fragment != null) {
            streamed = true;
            IncludeXMLConsumer.includeNode((Node)fragment, (ContentHandler)contentHandler, (LexicalHandler)lexicalHandler);
        }
        return streamed;
    }

    public void loadXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        throw new ProcessingException("The context " + this.name + " does not support loading.");
    }

    public void saveXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        throw new ProcessingException("The context " + this.name + " does not support saving.");
    }
}

