/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.components;

import java.util.HashMap;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.webapps.session.TransactionManager;
import org.apache.cocoon.webapps.session.context.SessionContext;

public final class DefaultTransactionManager
extends AbstractLogEnabled
implements Component,
ThreadSafe,
TransactionManager,
Contextualizable {
    protected Context context;

    private TransactionState getSessionContextsTransactionState(SessionContext context) {
        TransactionState state;
        Request request = ContextHelper.getRequest((Context)this.context);
        Session session = request.getSession(true);
        HashMap<SessionContext, TransactionState> transactionStates = (HashMap<SessionContext, TransactionState>)session.getAttribute(this.getClass().getName());
        if (transactionStates == null) {
            transactionStates = new HashMap<SessionContext, TransactionState>(5, 3.0f);
            session.setAttribute(this.getClass().getName(), transactionStates);
        }
        if ((state = (TransactionState)transactionStates.get(context)) == null) {
            state = new TransactionState();
            transactionStates.put(context, state);
        }
        return state;
    }

    public void resetTransactions(SessionContext context) {
        TransactionState ts = this.getSessionContextsTransactionState(context);
        ts.nr = 0;
        ts.nrtotal = 0;
        ts.nw = 0;
        ts.nwtotal = 0;
    }

    public synchronized void startReadingTransaction(SessionContext context) throws ProcessingException {
        TransactionState ts = this.getSessionContextsTransactionState(context);
        ++ts.nrtotal;
        while (ts.nw != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException local) {
                throw new ProcessingException("Interrupted", (Throwable)local);
            }
        }
        ++ts.nr;
    }

    public synchronized void stopReadingTransaction(SessionContext context) {
        TransactionState ts = this.getSessionContextsTransactionState(context);
        --ts.nr;
        --ts.nrtotal;
        if (ts.nrtotal == 0) {
            this.notify();
        }
    }

    public synchronized void startWritingTransaction(SessionContext context) throws ProcessingException {
        TransactionState ts = this.getSessionContextsTransactionState(context);
        ++ts.nwtotal;
        while (ts.nrtotal + ts.nw != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException local) {
                throw new ProcessingException("Interrupted", (Throwable)local);
            }
        }
        ts.nw = 1;
    }

    public synchronized void stopWritingTransaction(SessionContext context) {
        TransactionState ts = this.getSessionContextsTransactionState(context);
        ts.nw = 0;
        --ts.nwtotal;
        this.notifyAll();
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    private class TransactionState {
        public int nr = 0;
        public int nrtotal = 0;
        public int nw = 0;
        public int nwtotal = 0;

        private TransactionState() {
        }
    }
}

