/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.context;

import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.webapps.session.context.RequestSessionContext;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.webapps.session.context.SessionContextProvider;
import org.apache.cocoon.webapps.session.context.SimpleSessionContext;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;

public final class StandardSessionContextProvider
extends AbstractLogEnabled
implements SessionContextProvider,
ThreadSafe,
Contextualizable,
Serviceable,
Component,
Disposable {
    protected Context context;
    protected ServiceManager manager;
    protected XPathProcessor xpathProcessor;
    protected SourceResolver resolver;

    public SessionContext getSessionContext(String name) throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        SessionContext context = this.getContext(objectModel, name);
        if (context == null) {
            if (name.equals("temporary")) {
                context = new SimpleSessionContext(this.xpathProcessor, this.resolver);
                context.setup(name, null, null);
            } else if (name.equals("request")) {
                context = new RequestSessionContext();
                context.setup(name, null, null);
                ((RequestSessionContext)context).setup(objectModel, this.manager, this.xpathProcessor);
            }
            objectModel.put(this.getClass().getName() + name, context);
        }
        return context;
    }

    public boolean existsSessionContext(String name) throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        return this.getContext(objectModel, name) != null;
    }

    private SessionContext getContext(Map objectModel, String name) {
        RequestSessionContext r;
        SessionContext context = (SessionContext)objectModel.get(this.getClass().getName() + name);
        if (context != null && !name.equals("temporary") && name.equals("request") && (r = (RequestSessionContext)context).getRequest() != ObjectModelHelper.getRequest((Map)objectModel)) {
            context = null;
            objectModel.remove(this.getClass().getName() + name);
        }
        return context;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.xpathProcessor);
            this.manager.release((Object)this.resolver);
            this.resolver = null;
            this.xpathProcessor = null;
            this.manager = null;
        }
    }
}

