/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListImpl
implements NodeList {
    private Node[] nodelist;

    public NodeListImpl(NodeList list) {
        if (list == null || list.getLength() == 0) {
            this.nodelist = null;
        } else {
            this.nodelist = new Node[list.getLength()];
            int i = 0;
            while (i < list.getLength()) {
                this.nodelist[i] = list.item(i).cloneNode(true);
                ++i;
            }
        }
    }

    public NodeListImpl(Node[] nodes) {
        this.nodelist = nodes;
    }

    public NodeListImpl() {
    }

    public NodeListImpl(DocumentFragment fragment, String rootName) {
        if (fragment != null) {
            Element root = fragment.getOwnerDocument().createElementNS(null, rootName);
            while (fragment.hasChildNodes()) {
                Node current = fragment.getFirstChild();
                fragment.removeChild(current);
                root.appendChild(current);
            }
            this.nodelist = new Node[1];
            this.nodelist[0] = root;
        }
    }

    public void addNode(Node node) {
        if (this.nodelist == null) {
            this.nodelist = new Node[1];
            this.nodelist[0] = node;
        } else {
            Node[] copy = new Node[this.nodelist.length + 1];
            System.arraycopy(this.nodelist, 0, copy, 0, this.nodelist.length);
            copy[copy.length - 1] = node;
            this.nodelist = copy;
        }
    }

    public Node item(int index) {
        if (this.nodelist == null || index >= this.nodelist.length) {
            return null;
        }
        return this.nodelist[index];
    }

    public int getLength() {
        return this.nodelist == null ? 0 : this.nodelist.length;
    }
}

