/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import net.sourceforge.chaperon.model.extended.Pattern;
import net.sourceforge.chaperon.model.extended.PatternIterator;

public class PatternSet {
    private PatternSetEntry first = null;

    public PatternSet() {
    }

    public PatternSet(PatternIterator pattern) {
        while (pattern.hasNext()) {
            this.addPattern(pattern.next());
        }
    }

    public boolean addPattern(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        PatternSetEntry entry = this.first;
        while (entry != null) {
            if (entry.pattern == pattern) {
                return false;
            }
            entry = entry.next;
        }
        this.first = new PatternSetEntry(pattern, this.first);
        return true;
    }

    public boolean addPattern(PatternSet set) {
        boolean modified = false;
        PatternSetEntry entry = set.first;
        while (entry != null) {
            modified |= this.addPattern(entry.pattern);
            entry = entry.next;
        }
        return modified;
    }

    public PatternIterator getPattern() {
        return new PatternSetEntryIterator(this.first);
    }

    public boolean contains(Pattern pattern) {
        PatternSetEntry entry = this.first;
        while (entry != null) {
            if (entry.pattern == pattern) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int getPatternCount() {
        int count = 0;
        PatternSetEntry entry = this.first;
        while (entry != null) {
            ++count;
            entry = entry.next;
        }
        return count;
    }

    public void clear() {
        this.first = null;
    }

    public boolean equals(Object o) {
        if (o instanceof PatternSet) {
            PatternSet set = (PatternSet)o;
            if (set.getPatternCount() != this.getPatternCount()) {
                return false;
            }
            PatternSetEntry entry = this.first;
            while (entry != null) {
                PatternSetEntry foreignentry = set.first;
                while (foreignentry != null) {
                    if (entry.pattern == foreignentry.pattern) break;
                    if (foreignentry.next == null) {
                        return false;
                    }
                    foreignentry = foreignentry.next;
                }
                entry = entry.next;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        PatternSetEntry entry = this.first;
        while (entry != null) {
            if (entry != this.first) {
                buffer.append(",");
            }
            buffer.append(entry.pattern.toString());
            entry = entry.next;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public class PatternSetEntryIterator
    implements PatternIterator {
        private PatternSetEntry entry = null;

        private PatternSetEntryIterator(PatternSetEntry entry) {
            this.entry = entry;
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        public Pattern next() {
            Pattern pattern = this.entry.pattern;
            this.entry = this.entry.next;
            return pattern;
        }
    }

    private class PatternSetEntry {
        public final Pattern pattern;
        public final PatternSetEntry next;

        private PatternSetEntry(Pattern pattern, PatternSetEntry next) {
            this.pattern = pattern;
            this.next = next;
        }
    }
}

