/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.impl;

import org.apache.excalibur.event.EnqueuePredicate;
import org.apache.excalibur.event.Sink;

public class RateLimitingPredicate
implements EnqueuePredicate {
    private double m_targetRate;
    private int m_depth;
    private int m_tokenCount;
    private long m_lastTime;
    private double m_regenTimeMs;
    private static final long MIN_REGENERATION_TIME = 0L;

    public RateLimitingPredicate(int depth) {
        this(-1.0, depth);
    }

    public RateLimitingPredicate(double targetRate, int depth) {
        this.m_targetRate = targetRate;
        this.m_depth = depth;
        this.m_regenTimeMs = 1.0 / targetRate * 1000.0;
        if (this.m_regenTimeMs < 1.0) {
            this.m_regenTimeMs = 1.0;
        }
        this.m_tokenCount = depth;
        this.m_lastTime = System.currentTimeMillis();
    }

    public boolean accept(Object element, Sink sink) {
        if (this.m_targetRate == -1.0) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long delay = currentTime - this.m_lastTime;
        if (delay >= 0L) {
            double numTokens = (double)delay * 1.0 / (this.m_regenTimeMs * 1.0);
            this.m_tokenCount = (int)((double)this.m_tokenCount + numTokens);
            if (this.m_tokenCount > this.m_depth) {
                this.m_tokenCount = this.m_depth;
            }
            this.m_lastTime = currentTime;
        }
        if (this.m_tokenCount >= 1) {
            --this.m_tokenCount;
            return true;
        }
        return false;
    }

    public boolean accept(Object[] elements, Sink sink) {
        if (this.m_targetRate == -1.0) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long delay = currentTime - this.m_lastTime;
        if (delay >= 0L) {
            double numTokens = (double)delay * 1.0 / (this.m_regenTimeMs * 1.0);
            this.m_tokenCount = (int)((double)this.m_tokenCount + numTokens);
            if (this.m_tokenCount > this.m_depth) {
                this.m_tokenCount = this.m_depth;
            }
            this.m_lastTime = currentTime;
        }
        if (this.m_tokenCount >= elements.length) {
            this.m_tokenCount -= elements.length;
            return true;
        }
        return false;
    }

    public double getTargetRate() {
        return this.m_targetRate;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public int getBucketSize() {
        return this.m_tokenCount;
    }

    public void setTargetRate(double targetRate) {
        this.m_targetRate = targetRate;
        this.m_regenTimeMs = 1.0 / targetRate * 1000.0;
        if (this.m_regenTimeMs < 1.0) {
            this.m_regenTimeMs = 1.0;
        }
    }

    public void setDepth(int depth) {
        this.m_depth = depth;
    }

    static {
        MIN_REGENERATION_TIME = 0L;
    }
}

