/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleMap {
    public static final short IMPORTANT_MASK = 1;
    public static final short COMPUTED_MASK = 2;
    public static final short NULL_CASCADED_MASK = 4;
    public static final short LINE_HEIGHT_RELATIVE_MASK = 8;
    public static final short FONT_SIZE_RELATIVE_MASK = 16;
    public static final short COLOR_RELATIVE_MASK = 32;
    public static final short PARENT_RELATIVE_MASK = 64;
    public static final short BLOCK_WIDTH_RELATIVE_MASK = 128;
    public static final short BLOCK_HEIGHT_RELATIVE_MASK = 256;
    public static final short BOX_RELATIVE_MASK = 512;
    public static final short ORIGIN_MASK = -8192;
    public static final short USER_AGENT_ORIGIN = 0;
    public static final short USER_ORIGIN = 8192;
    public static final short NON_CSS_ORIGIN = 16384;
    public static final short AUTHOR_ORIGIN = 24576;
    public static final short INLINE_AUTHOR_ORIGIN = Short.MIN_VALUE;
    protected Value[] values;
    protected short[] masks;
    protected boolean fixedCascadedValues;

    public StyleMap(int n) {
        this.values = new Value[n];
        this.masks = new short[n];
    }

    public boolean hasFixedCascadedValues() {
        return this.fixedCascadedValues;
    }

    public void setFixedCascadedStyle(boolean bl) {
        this.fixedCascadedValues = bl;
    }

    public Value getValue(int n) {
        return this.values[n];
    }

    public short getMask(int n) {
        return this.masks[n];
    }

    public boolean isImportant(int n) {
        return (this.masks[n] & 1) != 0;
    }

    public boolean isComputed(int n) {
        return (this.masks[n] & 2) != 0;
    }

    public boolean isNullCascaded(int n) {
        return (this.masks[n] & 4) != 0;
    }

    public short getOrigin(int n) {
        return (short)(this.masks[n] & 0xFFFFE000);
    }

    public boolean isColorRelative(int n) {
        return (this.masks[n] & 0x20) != 0;
    }

    public boolean isParentRelative(int n) {
        return (this.masks[n] & 0x40) != 0;
    }

    public boolean isLineHeightRelative(int n) {
        return (this.masks[n] & 8) != 0;
    }

    public boolean isFontSizeRelative(int n) {
        return (this.masks[n] & 0x10) != 0;
    }

    public boolean isBlockWidthRelative(int n) {
        return (this.masks[n] & 0x80) != 0;
    }

    public boolean isBlockHeightRelative(int n) {
        return (this.masks[n] & 0x100) != 0;
    }

    public void putValue(int n, Value value) {
        this.values[n] = value;
    }

    public void putMask(int n, short s) {
        this.masks[n] = s;
    }

    public void putImportant(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFFFE);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? (short)1 : 0));
    }

    public void putOrigin(int n, short s) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0x1FFF);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (short)(s & 0xFFFFE000));
    }

    public void putComputed(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFFFD);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 2 : 0));
    }

    public void putNullCascaded(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFFFB);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 4 : 0));
    }

    public void putColorRelative(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFFDF);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 32 : 0));
    }

    public void putParentRelative(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFFBF);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 64 : 0));
    }

    public void putLineHeightRelative(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFFF7);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 8 : 0));
    }

    public void putFontSizeRelative(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFFEF);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 16 : 0));
    }

    public void putBlockWidthRelative(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFF7F);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 128 : 0));
    }

    public void putBlockHeightRelative(int n, boolean bl) {
        int n2 = n;
        this.masks[n2] = (short)(this.masks[n2] & 0xFFFFFEFF);
        int n3 = n;
        this.masks[n3] = (short)(this.masks[n3] | (bl ? 256 : 0));
    }

    public String toString(CSSEngine cSSEngine) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            Value value = this.values[i];
            if (value == null) continue;
            stringBuffer.append(cSSEngine.getPropertyName(i));
            stringBuffer.append(": ");
            stringBuffer.append(value);
            if (this.isImportant(i)) {
                stringBuffer.append(" !important");
            }
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }
}

