/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.w3c.dom.events.EventListener;

public class EventListenerList {
    private Entry first;
    private int n = 0;

    public EventListener[] getEventListeners() {
        if (this.first == null) {
            return null;
        }
        EventListener[] eventListenerArray = new EventListener[this.n];
        Entry entry = this.first;
        for (int i = 0; i < this.n; ++i) {
            eventListenerArray[i] = entry.listener;
            entry = entry.next;
        }
        return eventListenerArray;
    }

    public void add(EventListener eventListener) {
        this.first = new Entry(eventListener, this.first);
        ++this.n;
    }

    public void remove(EventListener eventListener) {
        if (this.first == null) {
            return;
        }
        if (this.first.listener == eventListener) {
            this.first = this.first.next;
            --this.n;
        } else {
            Entry entry = this.first;
            Entry entry2 = this.first.next;
            while (entry2 != null && entry2.listener != eventListener) {
                entry = entry2;
                entry2 = entry2.next;
            }
            if (entry2 != null) {
                entry.next = entry2.next;
                --this.n;
            }
        }
    }

    public boolean contains(EventListener eventListener) {
        Entry entry = this.first;
        while (entry != null) {
            if (eventListener == entry.listener) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int size() {
        return this.n;
    }

    private static class Entry {
        EventListener listener;
        Entry next;

        public Entry(EventListener eventListener, Entry entry) {
            this.listener = eventListener;
            this.next = entry;
        }
    }
}

