/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.filter.FrenchStandardFilter;
import fr.gouv.culture.sdx.search.lucene.analysis.filter.ISOLatin1AccentFilter;
import fr.gouv.culture.sdx.search.lucene.analysis.tokenizer.LetterOrDigitTokenizer;
import java.io.Reader;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;

public class Analyzer_fr
extends DefaultAnalyzer {
    protected static final String ANALYZER_TYPE = "Analyzer_fr";
    private boolean keepAccents = false;
    private static final String KEEP_ACCENTS_ATTRIBUTE = "keepAccents";

    protected String getAnalyzerType() {
        return ANALYZER_TYPE;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (configuration != null) {
            this.keepAccents = configuration.getAttributeAsBoolean(KEEP_ACCENTS_ATTRIBUTE, false);
        }
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new LetterOrDigitTokenizer(reader);
        FrenchStandardFilter fsf = new FrenchStandardFilter();
        fsf.enableLogging(this.logger);
        fsf.setUp((TokenStream)result);
        result = fsf;
        result = new LowerCaseFilter((TokenStream)result);
        if (!this.keepAccents) {
            ISOLatin1AccentFilter ilf = new ISOLatin1AccentFilter();
            ilf.enableLogging(this.logger);
            ilf.setUp((TokenStream)result);
            result = ilf;
        }
        if (this.stopTable != null) {
            result = new StopFilter((TokenStream)result, this.stopTable);
        }
        return result;
    }
}

