<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx xsl">
    <xsl:import href="skin.xsl"/>
    <xsl:param name="id" select="'admin'"/>
    <xsl:param name="pass" select="'admin'"/>
    <xsl:template match="rights">
        <h2>Droits</h2>
        <p>L'administration d'une application SDX peut être sécurisée,
        selon les notions courantes de "groupe" et d' "utilisateur".
        Pour cette application, des identités par défaut ont été définies
        dans le fichier de configuration : le groupe "admins", avec pour
        membre l'utilisateur "admin". L'accés aux bases de document est ici
        réservé aux membres du groupe "admins". L'utilisateur "admin"
        est donc autorisé, mais vous pouvez définir d'autres identités 
        (utilisateurs ou groupes) par l'interface suivante : 
        <a href="../sdx/admin/identities.xsp?app=fr.gouv.culture.sdx.sdxworld">
        ../sdx/admin
        </a>.
        <!--
        Pour accéder directement aux bases de cette application
        cliquez <a  class="but" href="admin.xsp">Documents</a>.
        -->
        </p>
    </xsl:template>
    <xsl:template match="login">
        <form style="margin:1em" action="login.xsp" method="post" name="login">
            <table border="0" cellpadding="5" cellspacing="0" align="center" class="form">
                <tr valign="top">
                    <td>Code d'utilisateur :</td>
                    <td>
                        <input name="id" size="30" type="text" value="{$id}"/>
                    </td>
                </tr>
                <tr valign="top">
                    <td>Mot de passe :</td>
                    <td>
                        <input name="pass" size="30" type="password" value="{$pass}"/>
                    </td>
                </tr>
                <tr valign="top" align="center">
                    <td colspan="2">
                        <input type="submit" value="Entrer"/>
                         <input type="submit" value="Déconnexion" name="logout"/>
                   </td>
                </tr>
            </table>
        </form>
    </xsl:template>
    <xsl:template match="identified">
        <div class="alert">
            <b>Votre identité a été reconnue.</b>
        </div>
    </xsl:template>
    <xsl:template match="anonymous">
        <div class="alert">
            Cette identité n'est pas connue pour cette application.
        </div>
    </xsl:template>
    <xsl:template match="admin">
        <div class="alert">
            <b>Vous appartenez au groupe : "admins" ; vous pouvez accéder à l'administration de cette application.</b>
        </div>
    </xsl:template>
</xsl:stylesheet>
