/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers.util;

public class DocType {
    protected String root_name = null;
    protected String public_id = null;
    protected String system_id = null;

    public DocType(String root_name) {
        this(root_name, null, null);
    }

    public DocType(String root_name, String system_id) {
        this(root_name, null, system_id);
    }

    public DocType(String root_name, String public_id, String system_id) {
        if (root_name == null) {
            throw new NullPointerException("Invalid root document name");
        }
        if (public_id != null && system_id == null) {
            throw new NullPointerException("Required System ID is NULL");
        }
        this.root_name = root_name;
        this.public_id = public_id;
        this.system_id = system_id;
    }

    public String getName() {
        return this.root_name;
    }

    public String getPublicId() {
        return this.public_id;
    }

    public String getSystemId() {
        return this.system_id;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof DocType)) {
            return false;
        }
        DocType doctype = (DocType)object;
        if (this.public_id == null ? doctype.public_id != null : !this.public_id.equals(doctype.public_id)) {
            return false;
        }
        if (this.system_id == null ? doctype.system_id != null : !this.system_id.equals(doctype.system_id)) {
            return false;
        }
        return this.root_name.equals(doctype.root_name);
    }
}

