/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ant;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.util.NetUtils;

public class UriType {
    private String uri;
    private Map parameters;
    private String deparameterizedUri;
    private String sUri;
    private String mangledUri;
    private String path;
    private String contentType;
    private File destFile;
    private Set links;

    public UriType(String uri) {
        String normalizedUri;
        this.uri = normalizedUri = NetUtils.normalize((String)uri);
        this.init();
    }

    public UriType(UriType parent, String uri) {
        if (parent != null) {
            String parentPath = parent.getPath();
            String absolutizedUri = NetUtils.absolutize((String)parentPath, (String)uri);
            this.uri = NetUtils.normalize((String)absolutizedUri);
        } else {
            String normalizedUri;
            this.uri = normalizedUri = NetUtils.normalize((String)uri);
        }
        this.init();
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Collection getLinks() {
        return this.links;
    }

    public String getUri() {
        return this.uri;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String getDeparameterizedUri() {
        return this.deparameterizedUri;
    }

    public String getSUri() {
        return this.sUri;
    }

    public String getMangledUri() {
        return this.mangledUri;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.mangledUri;
    }

    public String getExtension() {
        String filename = this.getFilename();
        return NetUtils.getExtension((String)filename);
    }

    public String getParameterizedUri(boolean addOriginalParameters, boolean addAdditionalParameters, Map additionalParameters) {
        HashMap mergedParameters = new HashMap();
        if (addOriginalParameters) {
            mergedParameters.putAll(this.parameters);
        }
        if (addAdditionalParameters && additionalParameters != null) {
            mergedParameters.putAll(additionalParameters);
        }
        String parameterizedUri = NetUtils.parameterize((String)this.deparameterizedUri, mergedParameters);
        return parameterizedUri;
    }

    public String getMergedParameterizedUri(Map additionalParameters) {
        return this.getParameterizedUri(false, true, additionalParameters);
    }

    public String getOriginalParameterizedUri() {
        return this.getParameterizedUri(true, false, null);
    }

    public void addLink(UriType uriType) {
        if (this.links == null) {
            this.links = new HashSet();
        }
        this.links.add(uriType);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof UriType) {
            UriType uriType = (UriType)o;
            if (uriType.uri != null && this.uri != null) {
                return uriType.uri.equals(this.uri);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    protected String mangledUri(String uri) {
        uri = uri.replace('\"', '\'');
        uri = uri.replace('?', '_');
        uri = uri.replace(':', '_');
        return uri;
    }

    protected void init() {
        if (this.uri != null) {
            this.parameters = new HashMap();
            this.deparameterizedUri = NetUtils.deparameterize((String)this.uri, (Map)this.parameters);
            this.sUri = NetUtils.parameterize((String)this.deparameterizedUri, (Map)this.parameters);
            this.mangledUri = this.mangledUri(this.sUri);
            this.path = NetUtils.getPath((String)this.uri);
            if (this.path.length() == 0) {
                this.path = "/";
            }
        }
    }
}

