/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.forms.datatype.ValidationRuleBuilder;
import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRule;
import org.apache.cocoon.forms.expression.ExpressionManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.excalibur.xml.sax.XMLizable;
import org.outerj.expression.Expression;
import org.outerj.expression.TokenMgrError;
import org.w3c.dom.Element;

public abstract class AbstractValidationRuleBuilder
implements ValidationRuleBuilder,
Serviceable,
Disposable {
    protected ExpressionManager expressionManager;
    protected ServiceManager serviceManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
        this.expressionManager = (ExpressionManager)serviceManager.lookup(ExpressionManager.ROLE);
    }

    protected void buildFailMessage(Element validationRuleElement, AbstractValidationRule rule) {
        Element failMessageElement = DomHelper.getChildElement(validationRuleElement, "http://apache.org/cocoon/forms/1.0#definition", "failmessage");
        if (failMessageElement != null) {
            XMLizable failMessage = DomHelper.compileElementContent(failMessageElement);
            rule.setFailMessage(failMessage);
        }
    }

    protected Expression parseExpression(String exprString, Element element, String attrName) throws Exception {
        try {
            return this.expressionManager.parse(exprString);
        }
        catch (TokenMgrError e) {
            throw new CascadingException("Error in expression \"" + exprString + "\" in attribute \"" + attrName + "\" at " + DomHelper.getLocation(element), (Throwable)e);
        }
        catch (Exception e) {
            throw new CascadingException("Error in expression \"" + exprString + "\" in attribute \"" + attrName + "\" at " + DomHelper.getLocation(element), (Throwable)e);
        }
    }

    public void dispose() {
        this.serviceManager.release((Object)this.expressionManager);
    }
}

