/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 5 nov. 2002
 * Time: 11:49:52
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import java.io.Reader;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanAnalyzer;

public class Analyzer_de extends DefaultAnalyzer {

	/**
	 * @see fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer#getAnalyserType()
	 */
	protected String getAnalyzerType() {
		return Analyzer_de.ANALYZER_TYPE;
	}
	protected final static String ANALYZER_TYPE="Analyzer_de";
	
    /*The analyzer to user*/
    private GermanAnalyzer germanAnalyzer = null;


    /**
     * Configures this analyzer.
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        // The super class will handle the stop words and exlusion stems
        super.configure(configuration);

        //if we have a stoptable we build the ge analyzer with it
        if (this.stopTable != null)
            this.germanAnalyzer = new GermanAnalyzer( (String[]) stopTable.toArray( new String[stopTable.size()] ) );
        	//this.germanAnalyzer = new GermanAnalyzer(((String[])stopTable.toArray()));
        else
            this.germanAnalyzer = new GermanAnalyzer();

        //if we have a exclusion table we provide it to the analyzer
        if (super.excludeTable != null)
            //this.germanAnalyzer.setStemExclusionTable(((String[])super.excludeTable.toArray()));
        	this.germanAnalyzer.setStemExclusionTable( (String[]) excludeTable.toArray( new String[excludeTable.size()] ) );
    }


    /**
     * Creates a TokenStream which tokenizes all the text in the provided Reader.
     *
     * @return  A TokenStream build from a StandardTokenizer filtered with
     *		StandardFilter, StopFilter, GermanStemFilter and LowerCaseFilter
     */
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.germanAnalyzer.tokenStream(fieldName, reader);
    }
}
