package fr.gouv.culture.sdx.utils.save;

import java.io.File;

//import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.constants.Node;


/**
 * @author jlecren
 *
 * This class contains the informations that are necessary to save and restore data.
 */
public class SaveParameters extends DefaultConfiguration{

	String _storePath;
	String _storeBasePath;
	long _unique_ID = 0;

	public SaveParameters( Configuration config, String storeBasePath) throws ConfigurationException
    {
        super( config.getName(), config.getLocation(), "","");
        this._storeBasePath = storeBasePath;
        _storePath = config.getAttribute(Saveable.PATH_ATTRIB,File.separator);
        addAll( config );

    }

	public SaveParameters( Configuration config, SaveParameters parent_config) throws ConfigurationException
    {
        super( config.getName(), config.getLocation(), "","");
        if(parent_config !=null){
        	parent_config.addChild(this);
			this._storeBasePath = parent_config.getStoreBasePath();
			_storePath = config.getAttribute(Saveable.PATH_ATTRIB,parent_config.getStorePath());
		}
        addAll( config );

    }

	public SaveParameters(String name, String storeBasePath)
	{
		this(name, null, storeBasePath, null);
	}

	public SaveParameters(String name, SaveParameters parent_config)
	{
		this(name, parent_config, null, null);
	}

	public SaveParameters(String name, SaveParameters parent_config, String storeRelativeDirectory)
	{
		this(name, parent_config, null, storeRelativeDirectory);
	}

	public SaveParameters(String name, SaveParameters parent_config, String storeBasePath, String storeRelativeDirectory)
	{
		super(name);
		this.setAttribute("all",String.valueOf(true));

		if(parent_config !=null){
			parent_config.addChild(this);
			if(storeRelativeDirectory != null)
				this._storePath = parent_config.getStorePath() + File.separator + storeRelativeDirectory;
			else
				this._storePath = parent_config.getStorePath();
			this._storeBasePath = parent_config.getStoreBasePath();
		}
		else
		{
			if(storeRelativeDirectory != null)
				this._storePath = storeRelativeDirectory;
			else
				this._storePath = "";
			this._storeBasePath = storeBasePath;
		}
	}

	/**
     * Add all child <code>Configuration</code> objects from specified
     * configuration element to current configuration element.
     *
     * @param other the other {@link Configuration} value
     */
	public void addAllChildren( final Configuration other )
    {
        checkWriteable();

        final Configuration[] children = other.getChildren();
        try{
	        for( int i = 0; i < children.length; i++ )
	        {
	            new SaveParameters(children[i],this);
	        }
        }catch(ConfigurationException e)
		{ //TODO : launch an error here or let the exception get through the method
		}
    }

	/**
	 * This method return the SaveParameters given a sdx_object id.
	 * @param sdxobjectid the id of the sdx object
	 * @return the save parameters of the sdxobject we are searching for,
	 * 			null if not found
	 */
	public SaveParameters getSaveParametersById(String sdxobjectid) throws SDXException
	{
		SaveParameters saveparams = null;
		for(int i=0; i< this.getChildren().length; i++)
		{
			if(this.getChildren()[i] instanceof SaveParameters)
			{
				saveparams = (SaveParameters)this.getChildren()[i];
				String id="";
				try{
					id = saveparams.getAttribute(Node.Name.ID);
				}catch(ConfigurationException e){
					throw new SDXException("Unable to get ID value in an entity",e);
				}
				if(id.equals(sdxobjectid))
					return saveparams;
			}
		}
		return null;
	}

	/**
	 * Get the relative path from base path where the current object data will be stored.
	 * @return the store path
	 */
	public String getStorePath()
	{
		return this._storePath;
	}

	/**
	 * Get the absolute path where all object are stored
	 * @return the store base path
	 */
	public String getStoreBasePath()
	{
		return this._storeBasePath;
	}

	/**
	 * Get the absolute path where the current is stored
	 * @return the store base path + the relative store path
	 */
	public String getStoreCompletePath()
	{
		return this._storeBasePath + this._storePath;
	}

	/**
	 * Set an unique ID for this saveconfig
	 * @return an unique ID
	 */
	public void setUniqueID(long id)
	{
		this._unique_ID = id;
	}

	/**
	 * Get an unique ID for this saveconfig
	 * AutoIncrement after each call.
	 * @return an unique ID
	 */
	public long getUniqueID()
	{
		return this._unique_ID++;
	}

	/**
	 * Get an unique ID for this saveconfig
	 * AutoIncrement after each call.
	 * @return an unique ID
	 */
	public String getUniqueIDString()
	{
		return String.valueOf(getUniqueID());
	}

	/**
	 * Add relative path in the config file
	 * @param pathleaf
	 */
	public void savePathInConfig(String pathleaf)
	{
		String path = "";
		if(pathleaf != null)
			path = this._storePath + File.separator + pathleaf;
		else
			path = this._storePath;
		path = Utilities.replaceAllSubString(path,File.separator,"/");
		this.setAttribute(Saveable.PATH_ATTRIB,path);
	}

	public boolean isAllElementSelected()
	{
		return getAttributeAsBoolean(Saveable.ALL_SAVE_ATTRIB,false);
	}


}
