/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.oai.OAIHarvester;
import fr.gouv.culture.oai.OAIRepository;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.DocumentBaseSourceValidity;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.oai.DocumentBaseOAIHarvester;
import fr.gouv.culture.sdx.pipeline.GenericPipeline;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractDocumentBase
extends DatabaseBacked
implements DocumentBase {
    protected boolean isDefault = false;
    protected int defaultHitsPerPage = 20;
    protected int defaultMaxSort = -1;
    protected Pipeline _indexationPipeline = null;
    protected Hashtable repositories = null;
    protected Repository defaultRepository = null;
    protected OAIRepository oaiRepo = null;
    protected Hashtable oaiRepositories = null;
    protected OAIHarvester _oaiHarv = null;
    protected Locale locale = null;
    protected Hashtable repoConnectionPool = null;
    IDGenerator idGen = null;
    protected final String PROPERTY_NAME_ATTACHED = "attached";
    protected final String PROPERTY_NAME_ORIGINAL = "original";
    protected final String PROPERTY_NAME_SUB = "sub";
    protected final String PROPERTY_NAME_PARENT = "parent";
    protected final String DBELEM_ATTRIBUTE_DEFAULT = "default";
    protected static final String DBELEM_ATTRIBUTE_MAXSORT = "maxsort";
    protected static final String DBELEM_ATTRIBUTE_HPP = "hpp";
    protected final String DBELEM_ATTRIBUTE_KEEP_ORIGINAL = "keepOriginalDocuments";
    protected final String ATTRIBUTE_COMPOUND_FILES = "useCompoundFiles";
    String ATTRIBUTE_USE_METADATA = "useMetadata";
    protected final String ATTRIBUTE_AUTO_OPTIMIZE = "autoOptimize";
    protected static final String ELEMENT_NAME_OPTIMIZE = "optimization";
    protected static final String ELEMENT_NAME_INDEX_SPLIT = "split";
    protected final String ATTRIBUTE_SPLIT_SIZE = "size";
    protected final String ATTRIBUTE_SPLIT_UNIT = "unit";
    protected final String ATTRIBUTE_SPLIT_DOC = "nbDocuments";
    public boolean useMetadata = true;
    protected static final String PROPERTY_NAME_REPO = "repo";
    protected static final String PROPERTY_NAME_MIMETYPE = "mimetype";
    protected static final String PROPERTY_NAME_CONTENT_LENGTH = "content-length";
    protected final String PROPERTY_NAME_DOCTYPE = "sdxDocType";
    public static final String INTERNAL_FIELD_NAME_SDXDOCID = "sdxdocid";
    public static final String INTERNAL_FIELD_NAME_SDXALL = "sdxall";
    public static final String INTERNAL_SDXALL_FIELD_VALUE = "1";
    public static final String INTERNAL_FIELD_NAME_SDXAPPID = "sdxappid";
    public static final String INTERNAL_FIELD_NAME_SDXDBID = "sdxdbid";
    public static final String INTERNAL_FIELD_NAME_SDXREPOID = "sdxrepoid";
    public static final String INTERNAL_FIELD_NAME_SDXDOCTYPE = "sdxdoctype";
    public static final String INTERNAL_FIELD_NAME_SDXMODDATE = "sdxmoddate";
    public static final String INTERNAL_FIELD_NAME_SDXCONTENTLENGTH = "sdxcontentlength";
    public static final String INTERNAL_FIELD_NAME_SDX_OAI_DELETED_RECORD = "sdxOaiDeletedRecord";

    public boolean isDefault() {
        return this.isDefault;
    }

    public int getOAIRepositoriesSize() {
        return this.oaiRepositories.size();
    }

    public final boolean isUseMetadata() {
        return this.useMetadata;
    }

    public int getDefaultHitsPerPage() {
        return this.defaultHitsPerPage;
    }

    public int getDefaultMaxSort() {
        return this.defaultMaxSort;
    }

    public Pipeline getIndexationPipeline() {
        try {
            return this._indexationPipeline.newInstance();
        }
        catch (SDXException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
            return null;
        }
    }

    public String getMimeType(Document doc) throws SDXException {
        DatabaseEntity ent = null;
        String mimeType = "application/octet-stream";
        Utilities.checkDocument(super.getLog(), doc);
        if (this.isUseMetadata()) {
            try {
                ent = this._database.getEntity(doc.getId());
            }
            catch (SDXException e) {
                return "application/octet-stream";
            }
            if (ent != null) {
                ent.enableLogging(super.getLog());
                mimeType = ent.getProperty(PROPERTY_NAME_MIMETYPE);
                if (!Utilities.checkString(mimeType)) {
                    mimeType = "application/octet-stream";
                }
            }
        }
        return mimeType;
    }

    protected void configurePipeline(Configuration configuration) throws ConfigurationException {
        this._indexationPipeline = new GenericPipeline();
        this._indexationPipeline = (Pipeline)super.setUpSdxObject(this._indexationPipeline);
        Configuration pipeConf = configuration.getChild("index", true).getChild("pipeline", false);
        if (pipeConf == null) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(16, args);
            LoggingUtils.logWarn(super.getLog(), sdxE.getMessage(), (Exception)((Object)sdxE));
        } else {
            this._indexationPipeline.configure(pipeConf);
        }
    }

    public void getDocument(ParsableDocument doc, XMLConsumer consumer) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkXmlConsumer(super.getLog(), consumer);
    }

    public void getDocument(Document doc, OutputStream os) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkOutputStream(super.getLog(), os);
    }

    public InputStream getDocument(Document doc) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        return null;
    }

    public Repository getDefaultRepository() {
        return this.defaultRepository;
    }

    public Repository getRepository(String id) throws SDXException {
        if (id == null) {
            return this.defaultRepository;
        }
        Repository repo = (Repository)this.repositories.get(id);
        if (repo == null) {
            String[] args = new String[]{id, super.getId()};
            throw new SDXException(super.getLog(), 1002, args, null);
        }
        return repo;
    }

    public OAIRepository createOAIRepository(String repo) throws ConfigurationException {
        LoggingUtils.logDebug(this._logger, "Create OAI repository " + repo);
        return this.getOAIRepository(repo);
    }

    public OAIRepository createOAIRepository() throws ConfigurationException {
        LoggingUtils.logDebug(this._logger, "Create default OAI repository");
        return this.getDefaultOAIRepository();
    }

    public OAIRepository getOAIRepository(String repo) {
        LoggingUtils.logDebug(this._logger, "Returning the OAI repository " + repo + " for the document base " + this._id);
        if (this.oaiRepositories == null || this.oaiRepositories.isEmpty()) {
            LoggingUtils.logWarn(this._logger, "The document base " + this._id + " has no OAI repository to return !", null);
            return null;
        }
        Hashtable oair = null;
        if (repo.equals("default") && this.oaiRepositories.size() == 1) {
            LoggingUtils.logDebug(this._logger, "Returns the alone OAI repository managed by the document base: " + this._id);
            oair = (Hashtable)this.oaiRepositories.get(this.oaiRepositories.keySet().toArray()[0]);
        } else if (Utilities.checkString(repo)) {
            LoggingUtils.logDebug(this._logger, "Returns the OAI repository " + repo + " managed by the document base: " + this._id);
            oair = (Hashtable)this.oaiRepositories.get(repo);
        } else {
            LoggingUtils.logDebug(this._logger, "The OAI repository " + repo + " does not exist. Returns the default one.");
            oair = (Hashtable)this.oaiRepositories.get("default");
        }
        if (oair != null && !oair.isEmpty()) {
            return (OAIRepository)oair.get("OAIRepository");
        }
        return null;
    }

    public OAIRepository getOAIRepository() {
        return this.getDefaultOAIRepository();
    }

    public OAIRepository getDefaultOAIRepository() {
        return this.getOAIRepository("default");
    }

    public OAIHarvester getOAIHarvester() {
        return this._oaiHarv;
    }

    protected void addOAIRepository(OAIRepository _repo, Configuration _conf, String _repoid) {
        if (!Utilities.checkString(_repoid)) {
            _repoid = this.oaiRepositories.size() + "";
        }
        Hashtable<String, OAIRepository> oair = new Hashtable<String, OAIRepository>(1);
        oair.put("OAIRepository", _repo);
        oair.put("configuration", (OAIRepository)_conf);
        this.oaiRepositories.put(_repoid, oair);
        this.oaiRepo = _repo;
    }

    protected void addOaiDeletedRecord(IndexableDocument doc) throws SDXException {
        this.managedOaiDeletedRecord(doc, "add");
    }

    protected void removeOaiDeletedRecord(IndexableDocument doc) throws SDXException {
        this.managedOaiDeletedRecord(doc, "remove");
    }

    protected void managedOaiDeletedRecord(IndexableDocument doc, String action) throws SDXException {
        LoggingUtils.logDebug(this._logger, "Managed the OAI document " + doc.getId() + " for " + action);
        if (Utilities.checkString(action) && doc != null && doc.getId() != null && this.oaiRepositories != null && !this.oaiRepositories.isEmpty()) {
            OAIRepository _oair = null;
            String _id = doc.getId();
            Enumeration r = this.oaiRepositories.elements();
            while (r.hasMoreElements()) {
                _oair = (OAIRepository)((Hashtable)r.nextElement()).get("OAIRepository");
                if (_oair == null) continue;
                if ("add".equals(action)) {
                    _oair.addDeletedRecord(_id);
                    continue;
                }
                if (!"remove".equals(action)) continue;
                _oair.removeDeletedRecord(_id);
            }
            _oair = null;
            _id = null;
        }
    }

    protected synchronized void optimizeDatabase() throws SDXException {
        if (this._database != null) {
            this._database.optimize();
        }
    }

    protected synchronized void optimizeRepositories() throws SDXException {
        Enumeration repos;
        if (this.repoConnectionPool != null && !this.repoConnectionPool.isEmpty() && (repos = this.repositories.elements()) != null) {
            while (repos.hasMoreElements()) {
                Repository repo = (Repository)repos.nextElement();
                if (repo == null) continue;
                repo.optimize();
            }
        }
    }

    protected synchronized void releasePooledRepositoryConnections() throws SDXException {
        Enumeration openConnections = null;
        if (this.repoConnectionPool != null) {
            openConnections = this.repoConnectionPool.keys();
        }
        if (openConnections != null) {
            while (openConnections.hasMoreElements()) {
                String repoId = (String)openConnections.nextElement();
                RepositoryConnection conn = (RepositoryConnection)this.repoConnectionPool.get(repoId);
                Repository repo = this.getRepository(repoId);
                if (repo != null && conn != null) {
                    conn.commit();
                    repo.releaseConnection(conn);
                }
                this.repoConnectionPool.remove(repoId);
            }
        }
    }

    protected synchronized RepositoryConnection getPooledRepositoryConnection(String repoId) throws SDXException {
        if (this.repoConnectionPool == null) {
            this.repoConnectionPool = new Hashtable();
        }
        RepositoryConnection conn = null;
        if (Utilities.checkString(repoId)) {
            if (this.repoConnectionPool.containsKey(repoId)) {
                conn = (RepositoryConnection)this.repoConnectionPool.get(repoId);
            } else {
                Repository repo = (Repository)this.repositories.get(repoId);
                if (repo != null && (conn = repo.getConnection()) != null) {
                    this.repoConnectionPool.put(repoId, conn);
                }
            }
        }
        return conn;
    }

    protected DatabaseEntity createEntityForDocMetaData(Document doc, Repository repository, String[] parentDocId) throws SDXException {
        if (this.useMetadata) {
            String length;
            DatabaseEntity docLookupEntry = new DatabaseEntity(doc.getId());
            docLookupEntry.enableLogging(super.getLog());
            if (repository != null) {
                docLookupEntry.addProperty(PROPERTY_NAME_REPO, repository.getId());
            }
            docLookupEntry.addProperty("sdxDocType", doc.getDocType());
            if (Utilities.checkString(doc.getMimeType())) {
                docLookupEntry.addProperty(PROPERTY_NAME_MIMETYPE, doc.getMimeType());
            }
            if (Utilities.checkString(length = Integer.toString(doc.getLength()))) {
                docLookupEntry.addProperty(PROPERTY_NAME_CONTENT_LENGTH, length);
            }
            docLookupEntry.addProperties("parent", parentDocId);
            return docLookupEntry;
        }
        return null;
    }

    public synchronized void delete(Document doc, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        Utilities.checkDocument(super.getLog(), doc);
        Document[] docs = new Document[]{doc};
        this.delete(docs, handler);
    }

    protected void deletePhysicalDocument(Document doc, Repository repo, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        Utilities.checkDocument(super.getLog(), doc);
        RepositoryConnection conn = null;
        DatabaseEntity ent = null;
        if (repo != null) {
            conn = this.getPooledRepositoryConnection(repo.getId());
            if (this.isUseMetadata()) {
                ent = this._database.getEntity(doc.getId());
            }
            if (conn != null) {
                repo.delete(doc, conn);
            }
        }
        if (handler != null) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "id", "id", "CDATA", doc.getId());
            if (repo != null) {
                atts.addAttribute("", PROPERTY_NAME_REPO, PROPERTY_NAME_REPO, "CDATA", repo.getId());
            }
            atts.addAttribute("", "base", "base", "CDATA", this.getId());
            String appId = Utilities.getStringFromContext("sdx.application.id", (Context)super.getContext());
            if (Utilities.checkString(appId)) {
                atts.addAttribute("", "app", "app", "CDATA", appId);
            }
            if (ent != null) {
                String length;
                String mimeType = ent.getProperty(PROPERTY_NAME_MIMETYPE);
                if (Utilities.checkString(mimeType)) {
                    atts.addAttribute("", PROPERTY_NAME_MIMETYPE, PROPERTY_NAME_MIMETYPE, "CDATA", mimeType);
                }
                if (Utilities.checkString(length = ent.getProperty(PROPERTY_NAME_CONTENT_LENGTH))) {
                    atts.addAttribute("", "byte-length", "byte-length", "CDATA", length);
                }
            }
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", "sdx:document", atts);
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", "sdx:document");
        }
    }

    public IDGenerator getIdGenerator() {
        return this.idGen;
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Indexation_Pipeline", this._indexationPipeline);
        if (this.defaultRepository != null) {
            this._xmlizable_objects.put("Default_Repository", this.defaultRepository.getId());
        }
        this._xmlizable_objects.put("Is_default", String.valueOf(this.isDefault()));
        this._xmlizable_objects.put("OAI_Repository", this.oaiRepo);
        this._xmlizable_objects.put("OAI_Harvester", this._oaiHarv);
        if (this.idGen != null) {
            this._xmlizable_objects.put("IDGenerator_Class", this.idGen.getClass().getName());
            this._xmlizable_objects.put("IDGenerator_Prefix", this.idGen.getPrefix());
            this._xmlizable_objects.put("IDGenerator_Suffix", this.idGen.getSuffix());
        } else {
            this._xmlizable_objects.put("IDGenerator_Class", "none");
            this._xmlizable_objects.put("IDGenerator_Prefix", "");
            this._xmlizable_objects.put("IDGenerator_Suffix", "");
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        this._xmlizable_objects.put("Is_default", String.valueOf(this.isDefault()));
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            save_config.setAttribute("id", this.getId());
            if (this._oaiHarv instanceof DocumentBaseOAIHarvester) {
                SaveParameters saveparams = new SaveParameters("oai-harvester", save_config);
                ((DocumentBaseOAIHarvester)this._oaiHarv).backup(saveparams);
            }
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            File db_dir = new File(save_config.getStoreCompletePath());
            if (!db_dir.exists()) {
                throw new SDXException(db_dir.getAbsolutePath() + " not found.");
            }
            if (this._oaiHarv instanceof DocumentBaseOAIHarvester) {
                SaveParameters saveparams = (SaveParameters)save_config.getChild("oai-harvester");
                ((DocumentBaseOAIHarvester)this._oaiHarv).restore(saveparams);
            }
        }
    }

    public SourceValidity getSourceValidity() {
        return new DocumentBaseSourceValidity(this);
    }
}

