/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.oai.OAIHarvester;
import fr.gouv.culture.oai.OAIRepository;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.search.Searchable;
import fr.gouv.culture.sdx.utils.SdxObject;
import fr.gouv.culture.sdx.utils.save.Saveable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public interface DocumentBase
extends SdxObject,
Searchable,
Saveable {
    public static final String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.documentbase.";
    public static final String CLASS_NAME_SUFFIX = "DocumentBase";

    public void init() throws SDXException, ConfigurationException;

    public boolean isDefault();

    public int getDefaultHitsPerPage();

    public int getDefaultMaxSort();

    public Repository getRepository(String var1) throws SDXException;

    public Repository getDefaultRepository();

    public Pipeline getIndexationPipeline();

    public void index(IndexableDocument var1, Repository var2, IndexParameters var3, ContentHandler var4) throws SDXException, SAXException, ProcessingException;

    public void index(IndexableDocument[] var1, Repository var2, IndexParameters var3, ContentHandler var4) throws SDXException, SAXException, ProcessingException;

    public void delete(Document var1, ContentHandler var2) throws SDXException, SAXException, ProcessingException;

    public void delete(Document[] var1, ContentHandler var2) throws SDXException, SAXException, ProcessingException;

    public void getDocument(ParsableDocument var1, XMLConsumer var2) throws SDXException;

    public void getDocument(ParsableDocument var1, XMLConsumer var2, boolean var3) throws SDXException;

    public void getDocument(Document var1, OutputStream var2) throws SDXException;

    public InputStream getDocument(Document var1) throws SDXException;

    public String getMimeType(Document var1) throws SDXException;

    public OAIRepository createOAIRepository() throws ConfigurationException;

    public OAIRepository getOAIRepository();

    public OAIRepository getOAIRepository(String var1);

    public int getOAIRepositoriesSize();

    public OAIHarvester getOAIHarvester();

    public Date lastModificationDate();

    public Date creationDate();

    public void optimize();

    public void checkIntegrity();

    public SourceValidity getSourceValidity();

    public static interface ConfigurationNode {
        public static final String INDEX = "index";
        public static final String PIPELINE = "pipeline";
        public static final String OAI_REPOSITORY = "oai-repository";
        public static final String OAI_HARVESTER = "oai-harvester";
        public static final String FIELD_LIST = "fieldList";
    }
}

