/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.JDBCDatabaseConnection;
import fr.gouv.culture.sdx.utils.database.Property;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.rdbms.DataSourceComponentBacked;
import fr.gouv.culture.sdx.utils.rdbms.JDBC;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;

public abstract class AbstractJDBCDatabase
extends DataSourceComponentBacked
implements Database {
    private static final long RESULT_MAX_SIZE = 5000L;
    protected final String FIELD_ID = "id";
    protected final String FIELD_PROPERTY_NAME = "propertyName";
    protected final String FIELD_PROPERTY_VALUE = "propertyValue";
    protected final int COLUMN_PARAM_INDEX_FIELD_ID = 1;
    protected final int COLUMN_PARAM_INDEX_FIELD_PROPERTY_NAME = 2;
    protected final int COLUMN_PARAM_INDEX_FIELD_PROPERTY_VALUE = 3;
    public static final String[] _searchModes = new String[]{"UNION", "INTERSECT", "EXCEPT"};

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (!Utilities.checkString(this.getId())) {
            throw new ConfigurationException("we dont have a valid id with which to build a table name");
        }
        this.tableName = Utilities.getStringFromContext("sdx.application.dirName", (Context)this.getContext()) + "_" + super.getId();
    }

    public DatabaseEntity getEntity(final String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return null;
        }
        DatabaseConnection sqldbConn = this.getConnection();
        Connection conn = sqldbConn.getConnection();
        String queryString = this.getEntityGetQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                DatabaseEntity l_dbe = null;

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, id);
                }

                public void collect(ResultSet rs) throws SQLException, SDXException {
                    this.l_dbe = AbstractJDBCDatabase.this.getEntity(id, rs);
                }

                public Object get() {
                    return this.l_dbe;
                }
            };
            template.execute(qe, 0);
            DatabaseEntity databaseEntity = (DatabaseEntity)qe.get();
            return databaseEntity;
        }
        catch (SDXException e) {
            String[] args = new String[]{id};
            throw new SDXException(super.getLog(), 302, args, (Throwable)((Object)e));
        }
        finally {
            this.releaseConnection(sqldbConn);
        }
    }

    public DatabaseEntity[] getEntities() throws SDXException {
        DatabaseConnection sqldbConn = this.getConnection();
        Connection conn = sqldbConn.getConnection();
        String queryString = this.getAllEntitiesQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                DatabaseEntity[] l_dbes = null;

                public void collect(ResultSet rs) throws SQLException, SDXException {
                    this.l_dbes = AbstractJDBCDatabase.this.getEntities(rs);
                }

                public Object get() {
                    return this.l_dbes;
                }
            };
            template.execute(qe, 0);
            DatabaseEntity[] databaseEntityArray = (DatabaseEntity[])qe.get();
            return databaseEntityArray;
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 303, args, (Throwable)((Object)e));
        }
        finally {
            this.releaseConnection(sqldbConn);
        }
    }

    public String getPropertyValue(String entityId, String name) throws SDXException {
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe == null || !Utilities.checkString(name)) {
            return null;
        }
        return dbe.getProperty(name);
    }

    public String[] getPropertyValues(String entityId, String propertyName) throws SDXException {
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe == null || !Utilities.checkString(propertyName)) {
            return null;
        }
        return dbe.getPropertyValues(propertyName);
    }

    public Property[] getProperties(String entityId) throws SDXException {
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe == null) {
            return null;
        }
        return dbe.getProperties();
    }

    public synchronized void save(DatabaseEntity ent) throws SDXException {
        if (ent == null) {
            return;
        }
        final String entityId = ent.getId();
        if (!Utilities.checkString(entityId)) {
            return;
        }
        final Property[] props = ent.getProperties();
        DatabaseConnection sqldbConn = this.getConnection();
        Connection conn = sqldbConn.getConnection();
        String queryString = this.getPropertyAddQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                    if (props != null && props.length > 0) {
                        for (int i = 0; i < props.length; ++i) {
                            String[] values = props[i].getValues();
                            if (values == null) continue;
                            for (int j = 0; j < values.length; ++j) {
                                ps.setString(1, entityId);
                                String propName = props[i].getName();
                                String propVal = values[j];
                                if (!Utilities.checkString(propName) || !Utilities.checkString(propVal)) continue;
                                ps.setString(2, propName);
                                ps.setString(3, propVal);
                                ps.executeUpdate();
                                ps.clearParameters();
                            }
                        }
                    } else {
                        ps.clearParameters();
                        ps.setString(1, entityId);
                        ps.setString(2, "");
                        ps.setString(3, "");
                        ps.executeUpdate();
                    }
                }
            };
            template.execute(qe, -1);
        }
        catch (SDXException e) {
            String[] args = new String[]{entityId, this.getId()};
            throw new SDXException(super.getLog(), 307, args, (Throwable)((Object)e));
        }
        finally {
            sqldbConn.commit();
            this.releaseConnection(sqldbConn);
        }
    }

    public synchronized void delete(DatabaseEntity ent) throws SDXException {
        String entityId;
        if (ent != null && Utilities.checkString(entityId = ent.getId())) {
            DatabaseConnection sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getEntityDeleteQuery();
            try {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                    public void prepare(PreparedStatement ps) throws SQLException {
                        ps.setString(1, entityId);
                    }
                };
                template.execute(qe, 1);
            }
            catch (SDXException e) {
                String[] args = new String[]{entityId, this.getId()};
                throw new SDXException(super.getLog(), 308, args, (Throwable)((Object)e));
            }
            finally {
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
            }
        }
    }

    public synchronized void delete(DatabaseEntity[] entities) throws SDXException {
        if (entities == null) {
            return;
        }
        Connection conn = null;
        String queryString = this.getEntityDeleteQuery();
        DatabaseConnection sqldbConn = this.getConnection();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            for (int i = 0; i < entities.length; ++i) {
                String entityId;
                DatabaseEntity ent = entities[i];
                if (ent == null || !Utilities.checkString(entityId = ent.getId()) || conn != null) continue;
                conn = sqldbConn.getConnection();
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                    public void prepare(PreparedStatement ps) throws SQLException {
                        ps.clearParameters();
                        ps.setString(1, entityId);
                    }
                };
                template.execute(qe, 1);
            }
        }
        catch (SDXException e) {
            String[] args = new String[2];
            args[0] = this.getId();
            throw new SDXException(super.getLog(), 309, args, (Throwable)((Object)e));
        }
        finally {
            sqldbConn.commit();
            this.releaseConnection(sqldbConn);
        }
    }

    public void update(DatabaseEntity ent) throws SDXException {
        if (ent != null) {
            this.delete(ent);
            this.save(ent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long size() {
        long l;
        DatabaseConnection sqldbConn = null;
        Connection conn = null;
        int ret = -1;
        try {
            try {
                sqldbConn = this.getConnection();
                conn = sqldbConn.getConnection();
                String queryString = "SELECT COUNT(DISTINCT id) FROM " + this.getTableName();
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                    int l_value = 0;

                    public void collect(ResultSet rs) throws SQLException {
                        if (rs.next()) {
                            this.l_value = rs.getInt(1);
                        }
                    }

                    public int value() {
                        return this.l_value;
                    }
                };
                template.execute(qe, 0);
                l = qe.value();
                Object var10_10 = null;
            }
            catch (SDXException e) {
                long l2 = ret;
                Object var10_11 = null;
                try {
                    this.releaseConnection(sqldbConn);
                    return l2;
                }
                catch (SDXException e2) {
                    LoggingUtils.logException(super.getLog(), (Exception)((Object)e2));
                }
                return l2;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {}
            catch (SDXException e2) {
                LoggingUtils.logException(super.getLog(), (Exception)((Object)e2));
                throw throwable;
            }
            this.releaseConnection(sqldbConn);
            throw throwable;
        }
        try {}
        catch (SDXException e2) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e2));
            return l;
        }
        this.releaseConnection(sqldbConn);
        return l;
    }

    public synchronized void empty() throws SDXException {
        DatabaseConnection sqlDbConn = this.getConnection();
        Connection conn = null;
        try {
            conn = sqlDbConn.getConnection();
            String queryString = this.getDeleteAllQuery();
            JDBC.Template template = new JDBC.Template(conn, queryString);
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){};
            template.execute(qe, 1);
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3003, args, (Throwable)((Object)e));
        }
        finally {
            sqlDbConn.commit();
            this.releaseConnection(sqlDbConn);
        }
    }

    public boolean entityExists(String id) {
        if (!Utilities.checkString(id)) {
            return false;
        }
        DatabaseEntity dbe = null;
        try {
            dbe = this.getEntity(id);
        }
        catch (SDXException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
            return false;
        }
        return dbe != null;
    }

    public String[] search(Parameters params) throws SDXException {
        if (params.getNames().length >= 2) {
            return this.searchWithParams(params);
        }
        return this.search(params, 1);
    }

    public String[] search(final Parameters params, int mode) throws SDXException {
        if (mode != 0 && mode != 1 && mode != 2) {
            return new String[0];
        }
        String modeString = _searchModes[mode];
        if (params == null) {
            return new String[0];
        }
        String[] entities = new String[]{};
        DatabaseConnection sqlDbConn = this.getConnection();
        Connection conn = sqlDbConn.getConnection();
        String queryString = "";
        String l_templateQueryString = "SELECT id FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
        final String[] paramNames = params.getNames();
        try {
            for (int i = 0; i < paramNames.length; ++i) {
                queryString = i == 0 ? queryString + l_templateQueryString : queryString + " " + modeString + " " + l_templateQueryString;
            }
            if (Utilities.checkString(queryString)) {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                    String[] l_dbes = null;

                    public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                        for (int j = 0; j < paramNames.length; ++j) {
                            int paramIdx = j * 2;
                            ps.setString(paramIdx + 1, paramNames[j]);
                            try {
                                ps.setString(paramIdx + 2, params.getParameter(paramNames[j]));
                                continue;
                            }
                            catch (ParameterException e) {
                                throw new SDXException(AbstractJDBCDatabase.this.getLog(), 114, null, e);
                            }
                        }
                    }

                    public void collect(ResultSet rs) throws SQLException, SDXException {
                        this.l_dbes = AbstractJDBCDatabase.this.getEntityIds(rs);
                    }

                    public Object get() {
                        return this.l_dbes;
                    }
                };
                template.execute(qe, 0);
                entities = (String[])qe.get();
            }
            String[] template = entities;
            return template;
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 306, args, (Throwable)((Object)e));
        }
        finally {
            this.releaseConnection(sqlDbConn);
        }
    }

    public String[] searchWithParams(final Parameters params) throws SDXException {
        if (params == null) {
            return new String[0];
        }
        String[] entities = new String[]{};
        DatabaseConnection sqlDbConn = this.getConnection();
        Connection conn = sqlDbConn.getConnection();
        String queryString = "";
        final String[] paramNames = params.getNames();
        String paramValue = null;
        for (int j = 0; j < paramNames.length; ++j) {
            try {
                paramValue = params.getParameter(paramNames[j]);
                continue;
            }
            catch (ParameterException e1) {
                e1.printStackTrace();
            }
        }
        try {
            if (paramNames.length < 2) {
                queryString = queryString + "SELECT id FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
            } else if (paramNames.length == 2) {
                queryString = queryString + "SELECT t1.id FROM " + this.getTableName() + " AS t1, " + this.getTableName() + " AS t2 ";
                queryString = queryString + " WHERE t1.propertyName = ? AND t1.propertyValue = ? ";
                queryString = queryString + " AND t2.propertyName = ? AND t2.propertyValue = ? ";
                queryString = queryString + " AND t1.id = t2.id";
            } else {
                String[] args = new String[]{this.getId(), "Search in database with more tha two parameters not implemented."};
                new SDXException(this.getLog(), 306, args, null);
            }
            if (Utilities.checkString(queryString)) {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                    String[] l_dbes = null;

                    public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                        for (int j = 0; j < paramNames.length; ++j) {
                            int paramIdx = j * 2;
                            ps.setString(paramIdx + 1, paramNames[j]);
                            try {
                                ps.setString(paramIdx + 2, params.getParameter(paramNames[j]));
                                continue;
                            }
                            catch (ParameterException e) {
                                throw new SDXException(AbstractJDBCDatabase.this.getLog(), 114, null, e);
                            }
                        }
                    }

                    public void collect(ResultSet rs) throws SQLException, SDXException {
                        this.l_dbes = AbstractJDBCDatabase.this.getEntityIds(rs);
                    }

                    public Object get() {
                        return this.l_dbes;
                    }
                };
                template.execute(qe, 0);
                entities = (String[])qe.get();
            }
            String[] template = entities;
            return template;
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 306, args, (Throwable)((Object)e));
        }
        finally {
            this.releaseConnection(sqlDbConn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        DatabaseConnection sqlDbConn;
        block10: {
            sqlDbConn = this.getConnection();
            Connection conn = null;
            ResultSet rs = null;
            try {
                try {
                    conn = sqlDbConn.getConnection();
                    DatabaseMetaData dbmd = conn.getMetaData();
                    rs = dbmd.getTables(null, null, this.getTableName(), null);
                    if (!rs.next()) {
                        this.createTable(conn);
                        this.createIndicies(conn);
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId()};
                    throw new SDXException(super.getLog(), 301, args, e);
                }
                Object var7_6 = null;
                if (rs == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(super.getLog(), 3200, args, e);
                    }
                }
                sqlDbConn.commit();
                this.releaseConnection(sqlDbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3200, args, e);
            }
            rs.close();
        }
        sqlDbConn.commit();
        this.releaseConnection(sqlDbConn);
    }

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "propertyName" + " VARCHAR(255) NOT NULL, " + "propertyValue" + " VARCHAR(255) NOT NULL, " + "PRIMARY KEY (" + "id" + "(255), " + "propertyName" + "(255), " + "propertyValue" + "(255) ))";
    }

    protected String getEntityGetQuery() {
        return "SELECT * FROM " + this.getTableName() + " WHERE " + "id" + " = ?";
    }

    protected String getAllEntitiesQuery() {
        return "SELECT * FROM " + this.getTableName();
    }

    protected abstract String getEntriesWithLimitQuery(long var1, long var3);

    protected String getEntityDeleteQuery() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "id" + " = ?";
    }

    protected String getPropertyAddQuery() {
        return "INSERT INTO " + this.getTableName() + " (" + "id" + "," + "propertyName" + "," + "propertyValue" + ") VALUES (?, ?, ?)";
    }

    protected String getPropertyRemoveQueryWithId() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "id" + " = ? AND " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
    }

    protected String getPropertyRemoveQueryWithoutId() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
    }

    protected String getDeleteAllQuery() {
        return "DELETE FROM " + this.getTableName();
    }

    protected String getCreateIndiciesQuery(String fieldName) {
        return "CREATE INDEX " + fieldName + " ON " + this.getTableName() + " (" + fieldName + ")";
    }

    protected DatabaseEntity getEntity(String id, ResultSet rs) throws SDXException {
        if (!Utilities.checkString(id) || rs == null) {
            return null;
        }
        DatabaseEntity dbe = null;
        try {
            while (rs.next()) {
                String rowid = rs.getString("id");
                String propName = rs.getString("propertyName");
                String propVal = rs.getString("propertyValue");
                if (!Utilities.checkString(rowid) || !id.equals(rowid)) continue;
                if (dbe == null) {
                    dbe = new DatabaseEntity(id);
                }
                dbe.addProperty(propName, propVal);
            }
            return dbe;
        }
        catch (SQLException e) {
            String[] args = new String[]{id};
            throw new SDXException(super.getLog(), 302, args, e);
        }
    }

    protected DatabaseEntity[] getEntities(ResultSet rs) throws SDXException {
        if (rs == null) {
            return null;
        }
        Hashtable<String, DatabaseEntity> entities = null;
        try {
            while (rs.next()) {
                if (entities == null) {
                    entities = new Hashtable<String, DatabaseEntity>();
                }
                String rowid = rs.getString("id");
                String propName = rs.getString("propertyName");
                String propVal = rs.getString("propertyValue");
                if (!Utilities.checkString(rowid) || !Utilities.checkString(propName)) continue;
                DatabaseEntity dbe = (DatabaseEntity)entities.get(rowid);
                if (dbe == null) {
                    dbe = new DatabaseEntity(rowid);
                }
                dbe.addProperty(propName, propVal);
                entities.put(rowid, dbe);
            }
            if (entities == null || entities.size() == 0) {
                return null;
            }
            return entities.values().toArray(new DatabaseEntity[0]);
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 303, args, e);
        }
    }

    protected String[] getEntityIds(ResultSet rs) throws SDXException {
        if (rs == null) {
            return new String[0];
        }
        ArrayList<String> ids = new ArrayList<String>();
        try {
            while (rs.next()) {
                String rowid = rs.getString("id");
                if (!Utilities.checkString(rowid)) continue;
                ids.add(rowid);
            }
            return ids.toArray(new String[0]);
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 303, args, e);
        }
    }

    protected void createIndicies(Connection conn) throws SDXException {
        try {
            JDBC.Template template = new JDBC.Template(conn, this.getCreateIndiciesQuery("id"));
            template.execute(new JDBC.QueryExecutor(){}, 1);
            template = new JDBC.Template(conn, this.getCreateIndiciesQuery("propertyName"));
            template.execute(new JDBC.QueryExecutor(){}, 1);
            template = new JDBC.Template(conn, this.getCreateIndiciesQuery("propertyValue"));
            template.execute(new JDBC.QueryExecutor(){}, 1);
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getTableName(), this.getId()};
            throw new SDXException(super.getLog(), 310, args, (Throwable)((Object)e));
        }
    }

    public void addProperty(final String entityId, final String propertyName, final String propertyValue) throws SDXException {
        if (!(Utilities.checkString(entityId) && Utilities.checkString(propertyName) && Utilities.checkString(propertyValue))) {
            return;
        }
        if (this.entityExists(entityId)) {
            DatabaseConnection sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getPropertyAddQuery();
            try {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                    public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                        ps.setString(1, entityId);
                        ps.setString(2, propertyName);
                        ps.setString(3, propertyValue);
                    }
                };
                template.execute(qe, 1);
            }
            catch (SDXException e) {
                String[] args = new String[]{entityId, this.getId()};
                throw new SDXException(super.getLog(), 311, args, (Throwable)((Object)e));
            }
            finally {
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
            }
        }
    }

    public void removeProperty(final String entityId, final String propertyName, final String propertyValue) throws SDXException {
        if (!(Utilities.checkString(entityId) && Utilities.checkString(propertyName) && Utilities.checkString(propertyValue))) {
            return;
        }
        if (this.entityExists(entityId)) {
            DatabaseConnection sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getPropertyRemoveQueryWithId();
            try {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                    public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                        ps.setString(1, entityId);
                        ps.setString(2, propertyName);
                        ps.setString(3, propertyValue);
                    }
                };
                template.execute(qe, 1);
            }
            catch (SDXException e) {
                String[] args = new String[]{entityId, this.getId()};
                throw new SDXException(super.getLog(), 312, args, (Throwable)((Object)e));
            }
            finally {
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
            }
        }
    }

    public void removeProperty(final String propertyName, final String propertyValue) throws SDXException {
        if (!Utilities.checkString(propertyName) || !Utilities.checkString(propertyValue)) {
            return;
        }
        DatabaseConnection sqldbConn = this.getConnection();
        Connection conn = sqldbConn.getConnection();
        String queryString = this.getPropertyRemoveQueryWithoutId();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                    ps.setString(2, propertyName);
                    ps.setString(3, propertyValue);
                }
            };
            template.execute(qe, 1);
        }
        catch (SDXException e) {
            String[] args = new String[]{propertyName, propertyValue, this.getId()};
            throw new SDXException(super.getLog(), 313, args, (Throwable)((Object)e));
        }
        finally {
            sqldbConn.commit();
            this.releaseConnection(sqldbConn);
        }
    }

    public DatabaseConnection getConnection() throws SDXException {
        try {
            JDBCDatabaseConnection dbConn = new JDBCDatabaseConnection(this.getDataSourceComponent());
            dbConn.enableLogging(this.getLog());
            dbConn.setAutoCommit(false);
            return dbConn;
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(this.getLog(), 3007, args, e);
        }
        catch (ServiceException e) {
            String[] args = new String[]{e.getMessage()};
            SDXException sdxE = new SDXException(null, 3201, args, e);
            String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
            throw new SDXException(this.getLog(), 3007, args2, (Throwable)((Object)sdxE));
        }
    }

    public void releaseConnection(DatabaseConnection conn) throws SDXException {
        if (conn != null) {
            if (conn.getConnection() != null) {
                ((JDBCDatabaseConnection)conn).releaseSqlConnection();
            }
            this.releaseDataSourceComponent(((JDBCDatabaseConnection)conn).getDataSource());
        }
    }

    protected String getClassNameSuffix() {
        return "Database";
    }

    public String getWildcardSearchToken() {
        return "%";
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("id", this.getId());
            save_config.savePathInConfig(null);
            String dir_name = save_config.getStoreBasePath() + File.separator + save_config.getAttribute("path", "");
            this.backupAllDatabaseEntries(dir_name);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void backupAllDatabaseEntries(String dir_name) throws SDXException {
        OutputStreamWriter file_out = null;
        DatabaseConnection sqldbConn = this.getConnection();
        Connection conn = sqldbConn.getConnection();
        try {
            try {
                file_out = new FileWriter(dir_name + File.separator + "data.bak");
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM " + this.getTableName());
                long num_entries = 0L;
                while (rs.next()) {
                    num_entries = rs.getLong(1);
                }
                long max_batch = num_entries / 5000L;
                if (num_entries % 5000L != 0L) {
                    ++max_batch;
                }
                for (long i = 0L; i < max_batch; ++i) {
                    rs = st.executeQuery(this.getEntriesWithLimitQuery(i * 5000L, 5000L));
                    while (rs.next()) {
                        file_out.write(rs.getString("id") + "\t");
                        file_out.write(rs.getString("propertyName") + "\t");
                        file_out.write(rs.getString("propertyValue") + "\r\n");
                    }
                }
                Object var14_14 = null;
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.getLog(), 8202, args, e);
            }
            catch (IOException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.getLog(), 8202, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (conn != null) {
                    this.releaseConnection(sqldbConn);
                }
                file_out.close();
                throw throwable;
            }
            catch (IOException ee) {
                String[] args = new String[]{this.getId(), ee.getMessage()};
                throw new SDXException(this.getLog(), 8202, args, ee);
            }
        }
        try {}
        catch (IOException ee) {
            String[] args = new String[]{this.getId(), ee.getMessage()};
            throw new SDXException(this.getLog(), 8202, args, ee);
        }
        if (conn != null) {
            this.releaseConnection(sqldbConn);
        }
        file_out.close();
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

