/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class PatternMatchExpression
extends Expression {
    private Pattern pattern;

    public PatternMatchExpression(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    protected int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + ". matches " + this.pattern.toString());
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public Iterator iterateSubExpressions() {
        return new PatternSponsor(this.pattern).iterateSubExpressions();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        return item instanceof NodeInfo && this.pattern.matches((NodeInfo)item, xPathContext);
    }
}

