/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.selection.AbstractSwitchSelector;
import org.apache.cocoon.util.ClassUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ExceptionSelector
extends AbstractSwitchSelector
implements Configurable {
    private Class[] clazz;
    private String[] name;
    private boolean[] unroll;

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration[] children = conf.getChildren("exception");
        this.clazz = new Class[children.length];
        this.name = new String[children.length];
        this.unroll = new boolean[children.length];
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String childClassName = child.getAttribute("class");
            Class childClass = null;
            try {
                childClass = ClassUtils.loadClass(childClassName);
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load class '" + childClassName + "' at " + child.getLocation());
            }
            for (int j = 0; j < i; ++j) {
                if (!this.clazz[j].isAssignableFrom(childClass)) continue;
                throw new ConfigurationException("Class '" + this.clazz[j].getName() + "' hides its subclass '" + childClassName + "' at " + child.getLocation());
            }
            this.clazz[i] = childClass;
            this.name[i] = child.getAttribute("name", null);
            this.unroll[i] = child.getAttributeAsBoolean("unroll", false);
            if (this.name[i] != null || this.unroll[i]) continue;
            throw new ConfigurationException("Must specify one of 'name' or 'unroll' at " + child.getLocation());
        }
    }

    public Object getSelectorContext(Map objectModel, Parameters parameters) {
        Throwable thr = ObjectModelHelper.getThrowable(objectModel);
        if (thr == null) {
            throw new IllegalStateException("No exception in object model. ExceptionSelector can only be used in <map:handle-errors>");
        }
        return this.find(thr);
    }

    private FindResult find(Throwable thr) {
        for (int i = 0; i < this.clazz.length; ++i) {
            FindResult result;
            Throwable cause;
            if (!this.clazz[i].isInstance(thr)) continue;
            if (this.unroll[i] && (cause = ExceptionUtils.getCause((Throwable)thr)) != null && (result = this.find(cause)) != null) {
                return result;
            }
            return new FindResult(this.name[i], thr);
        }
        return null;
    }

    public boolean select(String expression, Object selectorContext) {
        if (selectorContext == null) {
            return false;
        }
        boolean result = expression.equals(((FindResult)selectorContext).getName());
        if (result && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("select succesfull for condition " + selectorContext.toString());
        }
        return result;
    }

    static class FindResult {
        private String name;
        private Throwable throwable;

        public FindResult(String name, Throwable throwable) {
            this.name = name;
            this.throwable = throwable;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public String toString() {
            return this.name;
        }
    }
}

