/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.xml.SaxBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ParamSaxBuffer
extends SaxBuffer {
    private char[] previous_ch = null;

    public ParamSaxBuffer() {
    }

    public ParamSaxBuffer(SaxBuffer saxBuffer) {
        super(saxBuffer);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.previous_ch != null) {
            char[] buf = new char[length + this.previous_ch.length];
            System.arraycopy(this.previous_ch, 0, buf, 0, this.previous_ch.length);
            System.arraycopy(ch, start, buf, this.previous_ch.length, length);
            ch = buf;
            start = 0;
            length += this.previous_ch.length;
            this.previous_ch = null;
        }
        int end = start + length;
        for (int i = start; i < end; ++i) {
            int j;
            if (ch[i] != '{') continue;
            if (i > start) {
                this.addBit(new SaxBuffer.Characters(ch, start, i - start));
            }
            StringBuffer name = new StringBuffer();
            for (j = i + 1; j < end && ch[j] != '}'; ++j) {
                name.append(ch[j]);
            }
            if (j == end) {
                this.previous_ch = new char[end - i];
                System.arraycopy(ch, i, this.previous_ch, 0, end - i);
                break;
            }
            this.addBit(new Parameter(name.toString()));
            i = j;
            start = j + 1;
        }
        if (start < end) {
            this.addBit(new SaxBuffer.Characters(ch, start, end - start));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushChars();
        super.endElement(namespaceURI, localName, qName);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.flushChars();
        super.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushChars();
        super.processingInstruction(target, data);
    }

    public void startDocument() throws SAXException {
        this.flushChars();
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.flushChars();
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endDocument() throws SAXException {
        this.flushChars();
        super.endDocument();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushChars();
        super.comment(ch, start, length);
    }

    public void endDTD() throws SAXException {
        this.flushChars();
        super.endDTD();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.flushChars();
        super.startDTD(name, publicId, systemId);
    }

    private void flushChars() {
        if (this.previous_ch != null) {
            this.addBit(new SaxBuffer.Characters(this.previous_ch, 0, this.previous_ch.length));
            this.previous_ch = null;
        }
    }

    public void toSAX(ContentHandler contentHandler, Map parameters) throws SAXException {
        Iterator i = this.bits();
        while (i.hasNext()) {
            SaxBuffer.SaxBit saxbit = (SaxBuffer.SaxBit)i.next();
            if (saxbit instanceof Parameter) {
                ((Parameter)saxbit).send(contentHandler, parameters);
                continue;
            }
            saxbit.send(contentHandler);
        }
    }

    public String toString(Map parameters) throws SAXException {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.bits();
        while (i.hasNext()) {
            SaxBuffer.SaxBit saxbit = (SaxBuffer.SaxBit)i.next();
            if (saxbit instanceof Parameter) {
                ((Parameter)saxbit).toString(buffer, parameters);
                continue;
            }
            if (!(saxbit instanceof SaxBuffer.Characters)) continue;
            ((SaxBuffer.Characters)saxbit).toString(buffer);
        }
        return buffer.toString();
    }

    static final class Parameter
    implements SaxBuffer.SaxBit {
        private final String name;

        public Parameter(String name) {
            this.name = name;
        }

        public void send(ContentHandler contentHandler) {
        }

        public void send(ContentHandler contentHandler, Map parameters) throws SAXException {
            SaxBuffer value = (SaxBuffer)parameters.get(this.name);
            if (value != null) {
                value.toSAX(contentHandler);
            }
        }

        public void toString(StringBuffer result, Map parameters) throws SAXException {
            String value = (String)parameters.get(this.name);
            if (value != null) {
                result.append(value);
            }
        }

        public void dump(Writer writer) throws IOException {
            writer.write("[Parameter] name=" + this.name);
        }
    }
}

