/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.impl;

import org.eclipse.jdt.internal.compiler.ast.OperatorIds;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Util;

public abstract class Constant
implements TypeIds,
OperatorIds {
    public static final Constant NotAConstant = new DoubleConstant(Double.NaN);
    public static final IntConstant Zero = new IntConstant(0);
    public static final IntConstant Two = new IntConstant(2);
    public static final IntConstant One = new IntConstant(1);

    public boolean booleanValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotCastedInto", this.typeName(), "boolean"));
    }

    public byte byteValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotCastedInto", this.typeName(), "byte"));
    }

    public final Constant castTo(int conversionToTargetType) {
        if (this == NotAConstant) {
            return NotAConstant;
        }
        switch (conversionToTargetType) {
            case 0: {
                return this;
            }
            case 51: {
                return this;
            }
            case 55: {
                return Constant.fromValue((byte)this.longValue());
            }
            case 52: {
                return Constant.fromValue((byte)this.shortValue());
            }
            case 56: {
                return Constant.fromValue((byte)this.doubleValue());
            }
            case 57: {
                return Constant.fromValue((byte)this.floatValue());
            }
            case 50: {
                return Constant.fromValue((byte)this.charValue());
            }
            case 58: {
                return Constant.fromValue((byte)this.intValue());
            }
            case 115: {
                return Constant.fromValue((long)this.byteValue());
            }
            case 119: {
                return this;
            }
            case 116: {
                return Constant.fromValue((long)this.shortValue());
            }
            case 120: {
                return Constant.fromValue((long)this.doubleValue());
            }
            case 121: {
                return Constant.fromValue((long)this.floatValue());
            }
            case 114: {
                return Constant.fromValue((long)this.charValue());
            }
            case 122: {
                return Constant.fromValue((long)this.intValue());
            }
            case 67: {
                return Constant.fromValue((short)this.byteValue());
            }
            case 71: {
                return Constant.fromValue((short)this.longValue());
            }
            case 68: {
                return this;
            }
            case 72: {
                return Constant.fromValue((short)this.doubleValue());
            }
            case 73: {
                return Constant.fromValue((short)this.floatValue());
            }
            case 66: {
                return Constant.fromValue((short)this.charValue());
            }
            case 74: {
                return Constant.fromValue((short)this.intValue());
            }
            case 187: {
                return this;
            }
            case 131: {
                return Constant.fromValue((double)this.byteValue());
            }
            case 135: {
                return Constant.fromValue((double)this.longValue());
            }
            case 132: {
                return Constant.fromValue((double)this.shortValue());
            }
            case 136: {
                return this;
            }
            case 137: {
                return Constant.fromValue((double)this.floatValue());
            }
            case 130: {
                return Constant.fromValue((double)this.charValue());
            }
            case 138: {
                return Constant.fromValue((double)this.intValue());
            }
            case 147: {
                return Constant.fromValue((float)this.byteValue());
            }
            case 151: {
                return Constant.fromValue((float)this.longValue());
            }
            case 148: {
                return Constant.fromValue((float)this.shortValue());
            }
            case 152: {
                return Constant.fromValue((float)this.doubleValue());
            }
            case 153: {
                return this;
            }
            case 146: {
                return Constant.fromValue((float)this.charValue());
            }
            case 154: {
                return Constant.fromValue((float)this.intValue());
            }
            case 85: {
                return this;
            }
            case 35: {
                return Constant.fromValue((char)this.byteValue());
            }
            case 39: {
                return Constant.fromValue((char)this.longValue());
            }
            case 36: {
                return Constant.fromValue((char)this.shortValue());
            }
            case 40: {
                return Constant.fromValue((char)this.doubleValue());
            }
            case 41: {
                return Constant.fromValue((char)this.floatValue());
            }
            case 34: {
                return this;
            }
            case 42: {
                return Constant.fromValue((char)this.intValue());
            }
            case 163: {
                return Constant.fromValue((int)this.byteValue());
            }
            case 167: {
                return Constant.fromValue((int)this.longValue());
            }
            case 164: {
                return Constant.fromValue((int)this.shortValue());
            }
            case 168: {
                return Constant.fromValue((int)this.doubleValue());
            }
            case 169: {
                return Constant.fromValue((int)this.floatValue());
            }
            case 162: {
                return Constant.fromValue((int)this.charValue());
            }
            case 170: {
                return this;
            }
        }
        return NotAConstant;
    }

    public char charValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotCastedInto", this.typeName(), "char"));
    }

    public static final Constant computeConstantOperation(Constant cst, int id, int operator) {
        switch (operator) {
            case 11: {
                return Constant.fromValue(!cst.booleanValue());
            }
            case 14: {
                return cst;
            }
            case 13: {
                switch (id) {
                    case 9: {
                        float f = cst.floatValue();
                        if (f != 0.0f) break;
                        if (Float.floatToIntBits(f) == 0) {
                            return Constant.fromValue(-0.0f);
                        }
                        return Constant.fromValue(0.0f);
                    }
                    case 8: {
                        double d = cst.doubleValue();
                        if (d != 0.0) break;
                        if (Double.doubleToLongBits(d) == 0L) {
                            return Constant.fromValue(-0.0);
                        }
                        return Constant.fromValue(0.0);
                    }
                }
                return Constant.computeConstantOperationMINUS(Zero, 10, operator, cst, id);
            }
            case 12: {
                switch (id) {
                    case 2: {
                        return Constant.fromValue((int)(~cst.charValue()));
                    }
                    case 3: {
                        return Constant.fromValue((int)(~cst.byteValue()));
                    }
                    case 4: {
                        return Constant.fromValue((int)(~cst.shortValue()));
                    }
                    case 10: {
                        return Constant.fromValue(~cst.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(cst.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                }
                return NotAConstant;
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperation(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (operator) {
            case 2: {
                return Constant.computeConstantOperationAND(left, leftId, operator, right, rightId);
            }
            case 0: {
                return Constant.computeConstantOperationAND_AND(left, leftId, operator, right, rightId);
            }
            case 9: {
                return Constant.computeConstantOperationDIVIDE(left, leftId, operator, right, rightId);
            }
            case 6: {
                return Constant.computeConstantOperationGREATER(left, leftId, operator, right, rightId);
            }
            case 7: {
                return Constant.computeConstantOperationGREATER_EQUAL(left, leftId, operator, right, rightId);
            }
            case 10: {
                return Constant.computeConstantOperationLEFT_SHIFT(left, leftId, operator, right, rightId);
            }
            case 4: {
                return Constant.computeConstantOperationLESS(left, leftId, operator, right, rightId);
            }
            case 5: {
                return Constant.computeConstantOperationLESS_EQUAL(left, leftId, operator, right, rightId);
            }
            case 13: {
                return Constant.computeConstantOperationMINUS(left, leftId, operator, right, rightId);
            }
            case 15: {
                return Constant.computeConstantOperationMULTIPLY(left, leftId, operator, right, rightId);
            }
            case 3: {
                return Constant.computeConstantOperationOR(left, leftId, operator, right, rightId);
            }
            case 1: {
                return Constant.computeConstantOperationOR_OR(left, leftId, operator, right, rightId);
            }
            case 14: {
                return Constant.computeConstantOperationPLUS(left, leftId, operator, right, rightId);
            }
            case 16: {
                return Constant.computeConstantOperationREMAINDER(left, leftId, operator, right, rightId);
            }
            case 17: {
                return Constant.computeConstantOperationRIGHT_SHIFT(left, leftId, operator, right, rightId);
            }
            case 19: {
                return Constant.computeConstantOperationUNSIGNED_RIGHT_SHIFT(left, leftId, operator, right, rightId);
            }
            case 8: {
                return Constant.computeConstantOperationXOR(left, leftId, operator, right, rightId);
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationAND(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 5: {
                return Constant.fromValue(left.booleanValue() & right.booleanValue());
            }
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() & right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() & right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() & right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() & right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() & right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() & right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() & right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() & right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() & right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() & right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() & right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() & right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() & right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() & right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() & right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() & right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() & right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() & right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() & right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() & right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() & (long)right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() & (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() & (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() & (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() & right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationAND_AND(Constant left, int leftId, int operator, Constant right, int rightId) {
        return Constant.fromValue(left.booleanValue() && right.booleanValue());
    }

    public static final Constant computeConstantOperationDIVIDE(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() / right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() / right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() / right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() / right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() / right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() / right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() / right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() / (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() / right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() / right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() / (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() / (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() / (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() / (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() / (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() / (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() / right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() / (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() / (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() / (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() / (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() / right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() / right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() / right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() / right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() / right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() / right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() / right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() / right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() / right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() / right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() / right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() / right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() / right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() / right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() / right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() / right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() / right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() / right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() / right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() / right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() / right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() / (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() / right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() / right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() / (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() / (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() / (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() / right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationEQUAL_EQUAL(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 5: {
                if (rightId != 5) break;
                return Constant.fromValue(left.booleanValue() == right.booleanValue());
            }
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() == right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() == right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() == right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() == right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() == right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() == right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() == right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() == (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() == right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() == right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() == (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() == (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() == (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() == (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() == (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() == (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() == right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() == (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() == (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() == (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() == (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() == right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() == right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() == right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() == right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() == right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() == right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() == right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() == right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() == right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() == right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() == right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() == right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() == right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() == right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() == right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() == right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() == right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() == right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() == right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() == right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() == right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() == (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() == right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() == right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() == (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() == (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() == (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() == right.longValue());
                    }
                }
                break;
            }
            case 11: {
                if (rightId != 11) break;
                return Constant.fromValue(((StringConstant)left).compileTimeEqual((StringConstant)right));
            }
            case 12: {
                if (rightId == 11) {
                    return Constant.fromValue(false);
                }
                if (rightId != 12) break;
                return Constant.fromValue(true);
            }
        }
        return Constant.fromValue(false);
    }

    public static final Constant computeConstantOperationGREATER(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() > right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() > right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() > right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() > right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() > right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() > right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() > right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() > (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() > right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() > right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() > (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() > (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() > (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() > (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() > (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() > (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() > right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() > (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() > (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() > (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() > (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() > right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() > right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() > right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() > right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() > right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() > right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() > right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() > right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() > right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() > right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() > right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() > right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() > right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() > right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() > right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() > right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() > right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() > right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() > right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() > right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() > right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() > (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() > right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() > right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() > (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() > (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() > (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() > right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationGREATER_EQUAL(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() >= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() >= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() >= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() >= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() >= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() >= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() >= right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() >= (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() >= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() >= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() >= (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() >= (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() >= (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() >= (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() >= (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() >= (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() >= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() >= (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() >= (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() >= (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() >= (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() >= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() >= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() >= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() >= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() >= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() >= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() >= right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() >= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() >= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() >= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() >= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() >= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() >= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() >= right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() >= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() >= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() >= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() >= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() >= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() >= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() >= right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() >= (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() >= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() >= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() >= (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() >= (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() >= (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() >= right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLEFT_SHIFT(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() << right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() << right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() << right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() << right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.charValue() << (int)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() << right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() << right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() << right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() << right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.byteValue() << (int)right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() << right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() << right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() << right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() << right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.shortValue() << (int)right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() << right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() << right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() << right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() << right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.intValue() << (int)right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() << right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() << right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() << right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() << right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() << (int)right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLESS(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() < right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() < right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() < right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() < right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() < right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() < right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() < right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() < (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() < right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() < right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() < (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() < (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() < (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() < (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() < (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() < (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() < right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() < (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() < (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() < (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() < (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() < right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() < right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() < right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() < right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() < right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() < right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() < right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() < right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() < right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() < right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() < right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() < right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() < right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() < right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() < right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() < right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() < right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() < right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() < right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() < right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() < right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() < (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() < right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() < right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() < (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() < (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() < (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() < right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLESS_EQUAL(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() <= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() <= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() <= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() <= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() <= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() <= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() <= right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() <= (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() <= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() <= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() <= (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() <= (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() <= (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() <= (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() <= (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() <= (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() <= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() <= (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() <= (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() <= (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() <= (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() <= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() <= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() <= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() <= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() <= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() <= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() <= right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() <= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() <= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() <= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() <= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() <= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() <= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() <= right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() <= right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() <= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() <= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() <= right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() <= right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() <= right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() <= right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() <= (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() <= right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() <= right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() <= (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() <= (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() <= (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() <= right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationMINUS(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() - right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() - right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() - right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() - right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() - right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() - right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() - right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() - (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() - right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() - right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() - (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() - (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() - (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() - (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() - (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() - (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() - right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() - (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() - (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() - (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() - (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() - right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() - right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() - right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() - right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() - right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() - right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() - right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() - right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() - right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() - right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() - right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() - right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() - right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() - right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() - right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() - right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() - right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() - right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() - right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() - right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() - right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() - (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() - right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() - right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() - (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() - (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() - (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() - right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationMULTIPLY(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() * right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() * right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() * right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() * right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() * right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() * right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() * right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() * (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() * right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() * right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() * (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() * (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() * (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() * (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() * (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() * (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() * right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() * (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() * (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() * (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() * (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() * right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() * right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() * right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() * right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() * right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() * right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() * right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() * right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() * right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() * right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() * right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() * right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() * right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() * right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() * right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() * right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() * right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() * right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() * right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() * right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() * right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() * (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() * right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() * right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() * (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() * (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() * (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() * right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationOR(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 5: {
                return Constant.fromValue(left.booleanValue() | right.booleanValue());
            }
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() | right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() | right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() | right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() | right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() | right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() | right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() | right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() | right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() | right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() | right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() | right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() | right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() | right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() | right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() | right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() | right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() | right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() | right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() | right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() | right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() | (long)right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() | (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() | (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() | (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() | right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationOR_OR(Constant left, int leftId, int operator, Constant right, int rightId) {
        return Constant.fromValue(left.booleanValue() || right.booleanValue());
    }

    public static final Constant computeConstantOperationPLUS(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 1: {
                if (rightId == 11) {
                    return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                }
            }
            case 5: {
                if (rightId != 11) break;
                return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
            }
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() + right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() + right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() + right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() + right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() + right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() + right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() + right.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() + (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() + right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() + right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() + (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() + (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() + (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() + (float)right.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() + (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() + (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() + right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() + (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() + (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() + (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() + (double)right.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() + right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() + right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() + right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() + right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() + right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() + right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() + right.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() + right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() + right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() + right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() + right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() + right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() + right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() + right.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() + right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() + right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() + right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() + right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() + right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() + right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() + right.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() + (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() + right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() + right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() + (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() + (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() + (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() + right.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 11: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 9: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 8: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 3: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 4: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 10: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 7: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 5: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
                break;
            }
            case 12: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 9: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 8: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 3: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 4: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 10: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 7: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(left.stringValue()) + right.stringValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationREMAINDER(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() % right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.charValue() % right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.charValue() % right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() % right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() % right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() % right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() % right.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.floatValue() % (float)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.floatValue() % right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.floatValue() % right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.floatValue() % (float)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.floatValue() % (float)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.floatValue() % (float)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.floatValue() % (float)right.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.doubleValue() % (double)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(left.doubleValue() % (double)right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(left.doubleValue() % right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.doubleValue() % (double)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.doubleValue() % (double)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.doubleValue() % (double)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.doubleValue() % (double)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() % right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.byteValue() % right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.byteValue() % right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() % right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() % right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() % right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() % right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() % right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.shortValue() % right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.shortValue() % right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() % right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() % right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() % right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() % right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() % right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.intValue() % right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.intValue() % right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() % right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() % right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() % right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() % right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() % (long)right.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)left.longValue() % right.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)left.longValue() % right.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() % (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() % (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() % (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() % right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationRIGHT_SHIFT(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() >> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() >> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() >> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() >> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.charValue() >> (int)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() >> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() >> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() >> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() >> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.byteValue() >> (int)right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() >> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() >> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() >> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() >> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.shortValue() >> (int)right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() >> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() >> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() >> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() >> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.intValue() >> (int)right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() >> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() >> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() >> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() >> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() >> (int)right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationUNSIGNED_RIGHT_SHIFT(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() >>> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() >>> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() >>> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() >>> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.charValue() >>> (int)right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() >>> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() >>> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() >>> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() >>> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.byteValue() >>> (int)right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() >>> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() >>> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() >>> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() >>> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.shortValue() >>> (int)right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() >>> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() >>> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() >>> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() >>> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.intValue() >>> (int)right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() >>> right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() >>> right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() >>> right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() >>> right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() >>> (int)right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationXOR(Constant left, int leftId, int operator, Constant right, int rightId) {
        switch (leftId) {
            case 5: {
                return Constant.fromValue(left.booleanValue() ^ right.booleanValue());
            }
            case 2: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.charValue() ^ right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.charValue() ^ right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.charValue() ^ right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.charValue() ^ right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.charValue() ^ right.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.byteValue() ^ right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.byteValue() ^ right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.byteValue() ^ right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.byteValue() ^ right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.byteValue() ^ right.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.shortValue() ^ right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.shortValue() ^ right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.shortValue() ^ right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.shortValue() ^ right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.shortValue() ^ right.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.intValue() ^ right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.intValue() ^ right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.intValue() ^ right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.intValue() ^ right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)left.intValue() ^ right.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (rightId) {
                    case 2: {
                        return Constant.fromValue(left.longValue() ^ (long)right.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(left.longValue() ^ (long)right.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(left.longValue() ^ (long)right.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(left.longValue() ^ (long)right.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(left.longValue() ^ right.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public double doubleValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotCastedInto", this.typeName(), "double"));
    }

    public float floatValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotCastedInto", this.typeName(), "float"));
    }

    public static Constant fromValue(byte value) {
        return new ByteConstant(value);
    }

    public static Constant fromValue(char value) {
        return new CharConstant(value);
    }

    public static Constant fromValue(double value) {
        return new DoubleConstant(value);
    }

    public static Constant fromValue(float value) {
        return new FloatConstant(value);
    }

    public static Constant fromValue(int value) {
        return new IntConstant(value);
    }

    public static Constant fromValue(long value) {
        return new LongConstant(value);
    }

    public static Constant fromValue(String value) {
        return new StringConstant(value);
    }

    public static Constant fromValue(short value) {
        return new ShortConstant(value);
    }

    public static Constant fromValue(boolean value) {
        return new BooleanConstant(value);
    }

    public int intValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotCastedInto", this.typeName(), "int"));
    }

    public long longValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotCastedInto", this.typeName(), "long"));
    }

    public short shortValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotConvertedTo", this.typeName(), "short"));
    }

    public String stringValue() {
        throw new ShouldNotImplement(Util.bind("constant.cannotConvertedTo", this.typeName(), "String"));
    }

    public String toString() {
        if (this == NotAConstant) {
            return "(Constant) NotAConstant";
        }
        return super.toString();
    }

    public abstract int typeID();

    public String typeName() {
        switch (this.typeID()) {
            case 10: {
                return "int";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 2: {
                return "char";
            }
            case 9: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 5: {
                return "boolean";
            }
            case 7: {
                return "long";
            }
            case 11: {
                return "java.lang.String";
            }
            case 12: {
                return "null";
            }
        }
        return "unknown";
    }
}

