/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class RSSTransformer
extends AbstractSAXTransformer
implements CacheableProcessingComponent {
    protected XMLizer xmlizer;
    protected XMLDeserializer deserializer;
    protected XMLConsumer filter;

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        super.startElement(uri, name, raw, attributes);
        if ("description".equals(name)) {
            this.startTextRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endElement(String uri, String name, String raw) throws SAXException {
        if ("description".equals(name)) {
            Object parsed;
            String text;
            block7: {
                text = this.endTextRecording();
                String html = "<html><body>" + text + "</body></html>";
                parsed = null;
                XMLSerializer serializer = null;
                try {
                    try {
                        serializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(html.getBytes());
                        this.xmlizer.toSAX((InputStream)inputStream, "text/html", null, (ContentHandler)serializer);
                        parsed = serializer.getSAXFragment();
                    }
                    catch (Exception ignore) {
                        Object var10_11 = null;
                        this.manager.release((Object)serializer);
                        break block7;
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    this.manager.release((Object)serializer);
                    throw throwable;
                }
                this.manager.release((Object)serializer);
            }
            if (parsed != null) {
                this.deserializer.setConsumer(this.filter);
                this.deserializer.deserialize(parsed);
            } else {
                this.sendTextEvent(text);
            }
        }
        super.endElement(uri, name, raw);
    }

    public void recycle() {
        this.manager.release((Object)this.xmlizer);
        this.manager.release((Object)this.deserializer);
        this.xmlizer = null;
        this.deserializer = null;
        this.filter = null;
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.xmlizer = (XMLizer)this.manager.lookup(XMLizer.ROLE);
            this.deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Unable to lookup component.", (Throwable)ce);
        }
    }

    public void setupTransforming() throws IOException, ProcessingException, SAXException {
        super.setupTransforming();
        this.filter = new HTMLFilter(this.xmlConsumer);
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    class HTMLFilter
    extends IncludeXMLConsumer {
        int bodyCount;

        public HTMLFilter(XMLConsumer consumer) {
            super(consumer);
            this.bodyCount = 0;
        }

        public void startElement(String uri, String local, String qName, Attributes attr) throws SAXException {
            if (this.bodyCount > 0) {
                super.startElement(uri, local, qName, attr);
            }
            if ("body".equalsIgnoreCase(local)) {
                ++this.bodyCount;
            }
        }

        public void endElement(String uri, String local, String qName) throws SAXException {
            if ("body".equalsIgnoreCase(local)) {
                --this.bodyCount;
            }
            if (this.bodyCount > 0) {
                super.endElement(uri, local, qName);
            }
        }
    }
}

