/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/

package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.logger.Logger;

/**
 * A simple extension of AbstractPipeline.
 * <p>This pipeline allows query results to pass through a sax filter ({@link GetDocumentsTransformation}).
 * In this pipeline, a list of applications is necessary for the aforementioned sax filter.
 */
public class DeleteResultsPipeline extends GenericPipeline {

    private DeleteResultsTransformation drt = new DeleteResultsTransformation();

    public DeleteResultsPipeline() throws SDXException {
        this.addTransformation(drt);
    }

    /** Sets the super.getLog() for the pipeline
     *
     * @param logger   The super.getLog() created from Cocoon's logkit.
     */
    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        drt.enableLogging(logger);
    }

    /**
     * Sets the pipeline's ServiceManager.
     *
     * @param manager  The ServiceManager to use.
     * @throws ServiceException
     */
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        drt.service(manager);
    }

    /**Set's the id of the application from which the document's should be deleted
     *
     * @param appId
     */
    public void setApplicationId(String appId) throws SDXException {
        this.drt.setApplicationId(appId);
    }

}
