/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.lucene.document.Document;

/**
 *	A result document of a search.
 */
public class ResultDocument extends AbstractSdxObject implements LogEnabled {

    public static final String CLASS_NAME_SUFFIX = "ResultDocument";

    /** The Lucene document */
    private Document document;

    /** The relevance ranking. */
    private float score;

    /**Creates a ResultDocument object
     *
     * <p>
     * A super.getLog() must be set and then this object must be setUp.
     *
     * @see #enableLogging
     * @see #setUp
     */
    public ResultDocument() {
    }

    /**
     *	Builds a ResultDocument with a Lucene document and a relavance ranking.
     *
     * @param   doc     The Lucene document
     * @param   score   The relavance ranking
     */
    public void setUp(Document doc, float score) throws SDXException {
        if (doc == null) throw new SDXException(super.getLog(), SDXExceptionCode.ERROR_LUCENE_DOCUMENT_NULL, null, null);
        document = doc;
        this.score = score;
    }

    /**
     * Returns the value of a field within this document.
     *
     * This method never returns <code>null</code>,
     * it will turn over a <code>null</code> String
     * if the field does not exist.
     *
     *	@param	field	The name of the field.
     */
    public String getFieldValue(String field) {
        String fieldValue = document.get(field);
        if (fieldValue == null)
            return "";
        else
            return fieldValue;
    }

    /**
     *	Returns the relavance ranking for this document.
     */
    public float getScore() {
        return score;
    }

    /**
     *	Returns the Lucene document associated with this result.
     */
    public Document getDocument() {
        return document;
    }

    protected String getClassNameSuffix() {
        return ResultDocument.CLASS_NAME_SUFFIX;
    }

	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		return true;
	}

	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {
	
	}


}
