/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class Existence
extends SystemFunction {
    public static final int EXISTS = 0;
    public static final int EMPTY = 1;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], false);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        if ((sequenceIterator.getProperties() & 4) != 0) {
            switch (this.operation) {
                case 0: {
                    return ((LookaheadIterator)sequenceIterator).hasNext();
                }
                case 1: {
                    return !((LookaheadIterator)sequenceIterator).hasNext();
                }
            }
        } else {
            switch (this.operation) {
                case 0: {
                    return sequenceIterator.next() != null;
                }
                case 1: {
                    return sequenceIterator.next() == null;
                }
            }
        }
        return false;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }
}

