/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.cron.ConfigurableCronJob;
import org.apache.cocoon.components.cron.ServiceableCronJob;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class CocoonPipelineCronJob
extends ServiceableCronJob
implements Configurable,
ConfigurableCronJob {
    public static final String PIPELINE_PARAM = "pipeline";
    private String configuredPipeline;
    private String pipeline;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(String name) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CocoonPipelineCronJob: " + name + ", calling pipeline: " + this.pipeline);
        }
        SourceResolver resolver = null;
        Source src = null;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            try {
                int n;
                boolean append = this.getLogger().isInfoEnabled();
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                src = resolver.resolveURI("cocoon://" + this.pipeline);
                is = src.getInputStream();
                reader = new InputStreamReader(is);
                StringBuffer sb = new StringBuffer();
                char[] b = new char[8192];
                while ((n = reader.read(b)) > 0) {
                    if (!append) continue;
                    sb.append(b, 0, n);
                }
                reader.close();
                if (append) {
                    this.getLogger().info("CocoonPipelineCronJob: " + name + ", called pipeline: " + this.pipeline + ", and received following content:\n" + sb.toString());
                }
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("CocoonPipelineCronJob: " + name + ", raised an exception: ", (Throwable)e);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new CascadingRuntimeException("CocoonPipelineCronJob: " + name + ", raised an exception: ", (Throwable)e);
            }
            if (resolver != null) {
                resolver.release(src);
                this.manager.release((Object)resolver);
                resolver = null;
                src = null;
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            throw new CascadingRuntimeException("CocoonPipelineCronJob: " + name + ", raised an exception: ", (Throwable)e);
        }
        if (reader != null) {
            reader.close();
        }
        if (is != null) {
            is.close();
        }
        if (resolver != null) {
            resolver.release(src);
            this.manager.release((Object)resolver);
            return;
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.configuredPipeline = config.getChild(PIPELINE_PARAM).getValue(null);
    }

    public void setup(Parameters params, Map objects) {
        this.pipeline = params != null ? params.getParameter(PIPELINE_PARAM, this.configuredPipeline) : this.configuredPipeline;
    }
}

