/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.misc.TermInfo;
import org.apache.lucene.misc.TermInfoQueue;

public class HighFreqTerms {
    public static final int numTerms = 100;

    public static void main(String[] args) throws Exception {
        IndexReader reader = null;
        String field = null;
        if (args.length == 1) {
            reader = IndexReader.open((String)args[0]);
        } else if (args.length == 2) {
            reader = IndexReader.open((String)args[0]);
            field = args[1];
        } else {
            HighFreqTerms.usage();
            System.exit(1);
        }
        TermInfoQueue tiq = new TermInfoQueue(100);
        TermEnum terms = reader.terms();
        if (field != null) {
            while (terms.next()) {
                if (!terms.term().field().equals(field)) continue;
                tiq.insert(new TermInfo(terms.term(), terms.docFreq()));
            }
        } else {
            while (terms.next()) {
                tiq.insert(new TermInfo(terms.term(), terms.docFreq()));
            }
        }
        while (tiq.size() != 0) {
            TermInfo termInfo = (TermInfo)tiq.pop();
            System.out.println(termInfo.term + " " + termInfo.docFreq);
        }
        reader.close();
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [field]\n\n");
    }
}

