/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplets.basket;

import java.io.Serializable;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplets.basket.AbstractItem;

public class ContentItem
extends AbstractItem
implements Serializable {
    protected String copletId;
    protected boolean storesContent;
    protected String url;
    protected String stringRep;
    protected byte[] content;

    public ContentItem(CopletInstanceData cid, boolean content) {
        this.copletId = cid.getId();
        this.storesContent = content;
    }

    public ContentItem(String url, boolean content) {
        this.url = url;
        this.storesContent = content;
    }

    public String getURL() {
        return this.url;
    }

    public String getCopletId() {
        return this.copletId;
    }

    public boolean isContent() {
        return this.storesContent;
    }

    public void setContent(byte[] c) {
        this.storesContent = true;
        this.content = c;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int size() {
        if (this.content != null) {
            return this.content.length;
        }
        return -1;
    }

    public String toString() {
        if (this.stringRep == null) {
            this.stringRep = this.copletId != null ? "Coplet:" + this.copletId + "(" + this.storesContent + ")" : "URL:" + this.url + "(" + this.storesContent + ")";
        }
        return this.stringRep;
    }

    public boolean equalsItem(ContentItem ci) {
        if (ci != null && ci.storesContent == this.storesContent) {
            if (ci.url != null && ci.url.equals(this.url)) {
                return true;
            }
            if (ci.copletId != null && this.copletId != null && ci.copletId.equals(this.copletId)) {
                return true;
            }
        }
        return false;
    }
}

