/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.slop.generation;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.slop.interfaces.SlopParser;
import org.apache.cocoon.slop.parsing.SimpleSlopParser;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class SlopGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent {
    private Source inputSource = null;
    private String encoding = null;
    private SlopParser parser = null;
    private boolean preserveSpace = false;
    private String validTagnameChars = null;

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
        }
        this.inputSource = null;
        this.encoding = null;
        this.preserveSpace = false;
        this.parser = null;
        this.validTagnameChars = null;
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectmodel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectmodel, src, parameters);
        try {
            this.encoding = parameters.getParameter("encoding", null);
            this.preserveSpace = parameters.getParameterAsBoolean("preserve-space", false);
            this.validTagnameChars = parameters.getParameter("valid-tagname-chars", null);
            this.inputSource = resolver.resolveURI(src);
            SimpleSlopParser ssp = new SimpleSlopParser();
            this.parser = ssp;
            ssp.setPreserveWhitespace(this.preserveSpace);
            ssp.setValidTagnameChars(this.validTagnameChars);
        }
        catch (SourceException se) {
            throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)se);
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String line;
        InputStreamReader in = null;
        try {
            if (this.inputSource.getInputStream() == null) {
                throw new ProcessingException("Source '" + this.inputSource.getURI() + "' not found");
            }
            in = this.encoding != null ? new InputStreamReader(this.inputSource.getInputStream(), this.encoding) : new InputStreamReader(this.inputSource.getInputStream());
        }
        catch (SourceException se) {
            throw new ProcessingException("Error during resolving of '" + this.source + "'.", (Throwable)se);
        }
        LocatorImpl locator = new LocatorImpl();
        locator.setSystemId(this.inputSource.getURI());
        locator.setLineNumber(1);
        locator.setColumnNumber(1);
        this.contentHandler.setDocumentLocator(locator);
        this.parser.startDocument(this.contentHandler);
        LineNumberReader reader = new LineNumberReader(in);
        String newline = null;
        while ((line = newline == null ? reader.readLine() : newline) != null) {
            newline = reader.readLine();
            locator.setLineNumber(reader.getLineNumber());
            locator.setColumnNumber(1);
            this.parser.processLine(line);
            if (newline != null) continue;
        }
        this.parser.endDocument();
    }
}

