/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.jsp.JSPEngine;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.excalibur.source.Source;

public class JSPReader
extends ServiceableReader
implements Configurable {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private int bufferSize;
    private String outputEncoding;

    public void configure(Configuration conf) throws ConfigurationException {
        this.bufferSize = conf.getChild("buffer-size").getValueAsInteger(8192);
        this.outputEncoding = conf.getChild("output-encoding").getValue(null);
    }

    public void generate() throws IOException, ProcessingException {
        if (this.source == null) {
            throw new ProcessingException("JSPReader: source JSP is not specified");
        }
        HttpServletResponse servletResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
        HttpServletRequest servletRequest = (HttpServletRequest)this.objectModel.get("httprequest");
        ServletContext servletContext = (ServletContext)this.objectModel.get("httpservletcontext");
        if (servletResponse == null || servletRequest == null || servletContext == null) {
            throw new ProcessingException("JSPReader can only be used from within a Servlet environment.");
        }
        JSPEngine engine = null;
        Source inputSource = null;
        Source contextSource = null;
        try {
            try {
                inputSource = this.resolver.resolveURI(this.source);
                contextSource = this.resolver.resolveURI("context:/");
                String inputSourceURI = inputSource.getURI();
                String contextSourceURI = contextSource.getURI();
                if (!inputSourceURI.startsWith(contextSourceURI)) {
                    throw new ProcessingException("You must not reference a file outside of the servlet context at " + contextSourceURI + ".");
                }
                String url = inputSourceURI.substring(contextSourceURI.length());
                if (url.charAt(0) != '/') {
                    url = "/" + url;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("JSPReader executing:" + url);
                }
                engine = (JSPEngine)this.manager.lookup(JSPEngine.ROLE);
                byte[] bytes = engine.executeJSP(url, servletRequest, servletResponse, servletContext);
                if (this.outputEncoding != null) {
                    this.recodeResult(bytes, this.outputEncoding);
                } else {
                    this.out.write(bytes);
                    this.out.flush();
                }
                bytes = null;
            }
            catch (ServletException e) {
                throw new ProcessingException("ServletException while executing JSPEngine", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProcessingException("IOException JSPReader.generate()", (Throwable)e);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException("Exception JSPReader.generate()", (Throwable)e);
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.manager.release(engine);
            this.resolver.release(inputSource);
            this.resolver.release(contextSource);
            throw throwable;
        }
        this.manager.release((Object)engine);
        this.resolver.release(inputSource);
        this.resolver.release(contextSource);
    }

    private void recodeResult(byte[] bytes, String encoding) throws IOException {
        char[] buffer = new char[this.bufferSize];
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)bais, "UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(this.out, encoding);
        int length = -1;
        while ((length = reader.read(buffer)) > -1) {
            ((Writer)writer).write(buffer, 0, length);
        }
        ((Writer)writer).flush();
    }
}

