/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.ISourceField;
import org.eclipse.jdt.internal.compiler.env.ISourceImport;
import org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class SourceTypeConverter
implements CompilerModifiers {
    public static final int FIELD = 1;
    public static final int CONSTRUCTOR = 2;
    public static final int METHOD = 4;
    public static final int MEMBER_TYPE = 8;
    public static final int FIELD_INITIALIZATION = 16;
    public static final int FIELD_AND_METHOD = 7;
    public static final int NONE = 0;
    private int flags;
    private CompilationUnitDeclaration unit;
    private Parser parser;
    private ProblemReporter problemReporter;

    private SourceTypeConverter(int flags, ProblemReporter problemReporter) {
        this.flags = flags;
        this.problemReporter = problemReporter;
    }

    public static CompilationUnitDeclaration buildCompilationUnit(ISourceType[] sourceTypes, int flags, ProblemReporter problemReporter, CompilationResult compilationResult) {
        return new SourceTypeConverter(flags, problemReporter).convert(sourceTypes, compilationResult);
    }

    private CompilationUnitDeclaration convert(ISourceType[] sourceTypes, CompilationResult compilationResult) {
        ISourceImport[] sourceImports;
        this.unit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
        if (sourceTypes.length == 0) {
            return this.unit;
        }
        ISourceType sourceType = sourceTypes[0];
        if (sourceType.getName() == null) {
            return null;
        }
        int start = sourceType.getNameSourceStart();
        int end = sourceType.getNameSourceEnd();
        if (sourceType.getPackageName() != null && sourceType.getPackageName().length > 0) {
            this.unit.currentPackage = this.createImportReference(sourceType.getPackageName(), start, end, false, 0);
        }
        int importCount = (sourceImports = sourceType.getImports()) == null ? 0 : sourceImports.length;
        this.unit.imports = new ImportReference[importCount];
        int i = 0;
        while (i < importCount) {
            ISourceImport sourceImport = sourceImports[i];
            this.unit.imports[i] = this.createImportReference(sourceImport.getName(), sourceImport.getDeclarationSourceStart(), sourceImport.getDeclarationSourceEnd(), sourceImport.onDemand(), sourceImport.getModifiers());
            ++i;
        }
        int typeCount = sourceTypes.length;
        this.unit.types = new TypeDeclaration[typeCount];
        int i2 = 0;
        while (i2 < typeCount) {
            this.unit.types[i2] = this.convert(sourceTypes[i2], compilationResult);
            ++i2;
        }
        return this.unit;
    }

    private FieldDeclaration convert(ISourceField sourceField, TypeDeclaration type) {
        char[] initializationSource;
        FieldDeclaration field = new FieldDeclaration();
        int start = sourceField.getNameSourceStart();
        int end = sourceField.getNameSourceEnd();
        field.name = sourceField.getName();
        field.sourceStart = start;
        field.sourceEnd = end;
        field.type = this.createTypeReference(sourceField.getTypeName(), start, end);
        field.declarationSourceStart = sourceField.getDeclarationSourceStart();
        field.declarationSourceEnd = sourceField.getDeclarationSourceEnd();
        field.modifiers = sourceField.getModifiers();
        if ((this.flags & 0x10) != 0 && (initializationSource = sourceField.getInitializationSource()) != null) {
            if (this.parser == null) {
                this.parser = new Parser(this.problemReporter, true);
            }
            this.parser.parse(field, type, this.unit, initializationSource);
        }
        return field;
    }

    private AbstractMethodDeclaration convert(ISourceMethod sourceMethod, CompilationResult compilationResult) {
        AbstractMethodDeclaration method;
        AbstractMethodDeclaration decl;
        int start = sourceMethod.getNameSourceStart();
        int end = sourceMethod.getNameSourceEnd();
        if (sourceMethod.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.isDefaultConstructor = false;
            method = decl;
        } else {
            decl = new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = this.createTypeReference(sourceMethod.getReturnTypeName(), start, end);
            method = decl;
        }
        method.selector = sourceMethod.getSelector();
        method.modifiers = sourceMethod.getModifiers();
        method.sourceStart = start;
        method.sourceEnd = end;
        method.declarationSourceStart = sourceMethod.getDeclarationSourceStart();
        method.declarationSourceEnd = sourceMethod.getDeclarationSourceEnd();
        char[][] argumentTypeNames = sourceMethod.getArgumentTypeNames();
        char[][] argumentNames = sourceMethod.getArgumentNames();
        int argumentCount = argumentTypeNames == null ? 0 : argumentTypeNames.length;
        long position = ((long)start << 32) + (long)end;
        method.arguments = new Argument[argumentCount];
        int i = 0;
        while (i < argumentCount) {
            method.arguments[i] = new Argument(argumentNames[i], position, this.createTypeReference(argumentTypeNames[i], start, end), 0);
            ++i;
        }
        char[][] exceptionTypeNames = sourceMethod.getExceptionTypeNames();
        int exceptionCount = exceptionTypeNames == null ? 0 : exceptionTypeNames.length;
        method.thrownExceptions = new TypeReference[exceptionCount];
        int i2 = 0;
        while (i2 < exceptionCount) {
            method.thrownExceptions[i2] = this.createTypeReference(exceptionTypeNames[i2], start, end);
            ++i2;
        }
        return method;
    }

    private TypeDeclaration convert(ISourceType sourceType, CompilationResult compilationResult) {
        boolean needMethod;
        int i;
        char[][] interfaceNames;
        int end;
        int start;
        TypeDeclaration type = new TypeDeclaration(compilationResult);
        if (sourceType.getEnclosingType() != null) {
            type.bits |= 0x400;
        }
        type.name = sourceType.getName();
        type.sourceStart = start = sourceType.getNameSourceStart();
        type.sourceEnd = end = sourceType.getNameSourceEnd();
        type.modifiers = sourceType.getModifiers();
        type.declarationSourceStart = sourceType.getDeclarationSourceStart();
        type.bodyEnd = type.declarationSourceEnd = sourceType.getDeclarationSourceEnd();
        if (sourceType.getSuperclassName() != null) {
            type.superclass = this.createTypeReference(sourceType.getSuperclassName(), start, end);
        }
        int interfaceCount = (interfaceNames = sourceType.getInterfaceNames()) == null ? 0 : interfaceNames.length;
        type.superInterfaces = new TypeReference[interfaceCount];
        int i2 = 0;
        while (i2 < interfaceCount) {
            type.superInterfaces[i2] = this.createTypeReference(interfaceNames[i2], start, end);
            ++i2;
        }
        if ((this.flags & 8) != 0) {
            ISourceType[] sourceMemberTypes = sourceType.getMemberTypes();
            int sourceMemberTypeCount = sourceMemberTypes == null ? 0 : sourceMemberTypes.length;
            type.memberTypes = new TypeDeclaration[sourceMemberTypeCount];
            i = 0;
            while (i < sourceMemberTypeCount) {
                type.memberTypes[i] = this.convert(sourceMemberTypes[i], compilationResult);
                ++i;
            }
        }
        if ((this.flags & 1) != 0) {
            ISourceField[] sourceFields = sourceType.getFields();
            int sourceFieldCount = sourceFields == null ? 0 : sourceFields.length;
            type.fields = new FieldDeclaration[sourceFieldCount];
            i = 0;
            while (i < sourceFieldCount) {
                type.fields[i] = this.convert(sourceFields[i], type);
                ++i;
            }
        }
        boolean needConstructor = (this.flags & 2) != 0;
        boolean bl = needMethod = (this.flags & 4) != 0;
        if (needConstructor || needMethod) {
            ISourceMethod[] sourceMethods = sourceType.getMethods();
            int sourceMethodCount = sourceMethods == null ? 0 : sourceMethods.length;
            int extraConstructor = 0;
            int methodCount = 0;
            boolean isInterface = type.isInterface();
            if (!isInterface) {
                extraConstructor = needConstructor ? 1 : 0;
                int i3 = 0;
                while (i3 < sourceMethodCount) {
                    if (sourceMethods[i3].isConstructor()) {
                        if (needConstructor) {
                            extraConstructor = 0;
                            ++methodCount;
                        }
                    } else if (needMethod) {
                        ++methodCount;
                    }
                    ++i3;
                }
            } else {
                methodCount = needMethod ? sourceMethodCount : 0;
            }
            type.methods = new AbstractMethodDeclaration[methodCount + extraConstructor];
            if (extraConstructor != 0) {
                type.methods[0] = type.createsInternalConstructor(false, false);
            }
            int index = 0;
            int i4 = 0;
            while (i4 < sourceMethodCount) {
                ISourceMethod sourceMethod = sourceMethods[i4];
                boolean isConstructor = sourceMethod.isConstructor();
                if (isConstructor && needConstructor || !isConstructor && needMethod) {
                    AbstractMethodDeclaration method = this.convert(sourceMethod, compilationResult);
                    if (isInterface || method.isAbstract()) {
                        method.modifiers |= 0x1000000;
                    }
                    type.methods[extraConstructor + index++] = method;
                }
                ++i4;
            }
        }
        return type;
    }

    private ImportReference createImportReference(char[] importName, int start, int end, boolean onDemand, int modifiers) {
        char[][] qImportName = CharOperation.splitOn('.', importName);
        long[] positions = new long[qImportName.length];
        long position = ((long)start << 32) + (long)end;
        int i = 0;
        while (i < qImportName.length) {
            positions[i] = position;
            ++i;
        }
        return new ImportReference(qImportName, positions, onDemand, modifiers);
    }

    private TypeReference createTypeReference(char[] typeSignature, int start, int end) {
        int max;
        int dimStart = max = typeSignature.length;
        int dim = 0;
        int identCount = 1;
        int i = 0;
        while (i < max) {
            switch (typeSignature[i]) {
                case '[': {
                    if (dim == 0) {
                        dimStart = i;
                    }
                    ++dim;
                    break;
                }
                case '.': {
                    ++identCount;
                }
            }
            ++i;
        }
        if (identCount == 1) {
            if (dim == 0) {
                return new SingleTypeReference(typeSignature, ((long)start << 32) + (long)end);
            }
            char[] identifier = new char[dimStart];
            System.arraycopy(typeSignature, 0, identifier, 0, dimStart);
            return new ArrayTypeReference(identifier, dim, ((long)start << 32) + (long)end);
        }
        long[] positions = new long[identCount];
        long pos = ((long)start << 32) + (long)end;
        int i2 = 0;
        while (i2 < identCount) {
            positions[i2] = pos;
            ++i2;
        }
        char[][] identifiers = CharOperation.splitOn('.', typeSignature, 0, dimStart);
        if (dim == 0) {
            return new QualifiedTypeReference(identifiers, positions);
        }
        return new ArrayQualifiedTypeReference(identifiers, dim, positions);
    }
}

