/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.logging;

import org.apache.avalon.framework.logger.Logger;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.Utilities;

public class LoggingUtils {

	/**Logs an information message
	 *
	 * @param logger    The super.getLog()
	 * @param s         The message
	 */
	public static void logInfo(Logger logger, String s) {
		if ( Utilities.checkString(s) && logger != null && logger.isInfoEnabled() )
			logger.info(s);
	}
	public static void logInfo(Logger logger, int code, String[] arguments) {
		if (null != logger && logger.isInfoEnabled()) {
        	logger.info( new SDXException(code, arguments).getMessage() );
		}
	}

	/**Logs a debug message
	 *
	 * @param logger    The super.getLog()
	 * @param s         The message (maybe null)
	 * @param e         The exception (maybe null)
	 */
	public static void logDebug(Logger logger, String s, Exception e) {
		if ( logger != null && logger.isDebugEnabled() ) {
			if (Utilities.checkString(s)) {
				if (e != null) {
					logger.debug(s, e);
				} else {
					logger.debug(s);
				}
			} else if (e != null && (e.getMessage() != null & e.fillInStackTrace() != null)) {
				logger.debug(e.getMessage(), e.fillInStackTrace());
			}
		}
	}
	/**
	 * 
	 * @see #logDebug(Logger, String, Exception)
	 */
	public static void logDebug(Logger logger, String s) {
		logDebug(logger, s, null);
	}
	public static void logDebug (Logger logger, int code, String[] arguments) {
		if (null != logger && logger.isDebugEnabled()) {
        	logger.debug( new SDXException(code, arguments).getMessage() );
		}
	}

	/**Logs an error
	 *
	 * @param logger    The super.getLog()
	 * @param s         The message (maybe null)
	 * @param e         The exception (maybe null)
	 */
	public static void logError(Logger logger, String s, Throwable e) {
		if ( logger != null && logger.isErrorEnabled() ) {
			if (Utilities.checkString(s)) {
				if (e != null) {
					logger.error(s, e);
				} else
					logger.error(s);
			} else if (e != null && (e.getMessage() != null & e.fillInStackTrace() != null)) {
				logger.error(e.getMessage(), e.fillInStackTrace());
			}
		}
	}
	
	/**
	 * @see #logError(Logger, String, Throwable)
	 */
	public static void logError(Logger logger, String s) {
		logError(logger, s, null);
	}
	public static void logError (Logger logger, int code, String[] arguments) {
		if (null != logger && logger.isErrorEnabled()) {
        	logger.error( new SDXException(code, arguments).getMessage() );
		}
	}

	/**Logs a warning message
	 *
	 * @param logger    The super.getLog()
	 * @param s         The message (maybe null)
	 * @param e         The exception (maybe null)
	 */
	public static void logWarn(Logger logger, String s, Exception e) {
		if ( logger != null && logger.isWarnEnabled() ) {
			if (Utilities.checkString(s)) {
				if (e != null) {
					logger.warn(s, e);
				} else
					logger.warn(s);
			} else if (e != null)
				logger.warn(e.getMessage(), e);

		}
	}
	public static void logWarn (Logger logger, int code, String[] arguments) {
		if (null != logger && logger.isWarnEnabled()) {
        	logger.warn( new SDXException(code, arguments).getMessage() );
		}
	}
	
	/**
	 * @see #logWarn(Logger, String, Exception)
	 */
	public static void logWarn(Logger logger, String s) {
		logWarn(logger, s, null);
	}

	/**Logs an exception
	 *
	 * @param logger    The super.getLog()
	 * @param e         The exception (maybe null)
	 */
	public static void logException(Logger logger, Exception e) {
		if ( logger != null && logger.isErrorEnabled() && e != null 
					&& ( e.getMessage() != null && e.fillInStackTrace() != null) ){ 
			logger.error(e.getMessage(), e.fillInStackTrace());
		}
	}
}
