/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.rdbms;

import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

/**This class will handle connections manaagement within the scope
 * of the coocoon jdbc connection pool
 *
 */
public abstract class DataSourceComponentBacked extends JDBC implements Serviceable, Configurable {
/*This class should in the configure() method get the dbselector from cocoon
 and  then manage all requests for DataSourceComponentS
*/

    /** The data source _identifier. */
    protected String dsi;

    /** The component selector. */
    protected ServiceSelector dbSelector;

    /**String representation of the "repository" attribute name "dsi", for dataSourceIdentifier (name of connection in cocoon.xconf). */
    protected final String ATTRIBUTE_DSI = "dsi";


    /** Compose the object so that we get the <code>Service</code>s we need from the
     * <code>ServiceManager</code>.
     * @param manager   The service manager from Cocoon that allow us to acquire a database selector service.
     * @throws org.apache.avalon.framework.service.ServiceException
     */
    public void service(ServiceManager manager) throws ServiceException {
        //setting the manager
        super.service(manager);

        ServiceManager l_manager = super.getServiceManager();
        if (l_manager != null)
            this.dbSelector = (ServiceSelector) l_manager.lookup(DataSourceComponent.ROLE + "Selector");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        // We will need to keep the datasource _identifier here
        this.dsi = configuration.getAttribute(ATTRIBUTE_DSI, null);
    }

    /**Get's the datasource service from Cocoon using the dbSelector and the dsi
     * class variables
     *
     * @return
     * @throws ServiceException
     */
    protected DataSourceComponent getDataSourceComponent() throws ServiceException {
        if (this.dbSelector == null || !Utilities.checkString(this.dsi)) return null;
        return (DataSourceComponent) dbSelector.select(dsi);
    }

    /***Releases the data source service using the dbSelector
     *
     * @param dsc   The service to release
     */
    protected void releaseDataSourceComponent(DataSourceComponent dsc) {
        if (this.dbSelector != null && dsc != null) this.dbSelector.release(dsc);
    }

    protected void finalize() throws Throwable {
        ServiceManager l_manager = super.getServiceManager();
        l_manager.release(dbSelector);
    }


}
