/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.util.Stack;
import org.apache.cocoon.portal.LinkService;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.event.impl.CopletLinkEvent;
import org.apache.cocoon.portal.transformation.AbstractCopletTransformer;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EventLinkTransformer
extends AbstractCopletTransformer {
    public static final String NAMESPACE_URI = "http://apache.org/cocoon/portal/eventlink/1.0";
    public static final String EVENT_ELEM = "event";
    public static final String ATTRIBUTE_ATTR = "attribute";
    public static final String ELEMENT_ATTR = "element";
    private boolean insideEvent = false;
    private String attributeName = null;
    private String elementName = null;
    private Stack attrStack = new Stack();

    public void recycle() {
        super.recycle();
        this.insideEvent = false;
        this.attributeName = null;
        this.elementName = null;
        this.attrStack.clear();
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (uri.equals(NAMESPACE_URI) && name.equals(EVENT_ELEM)) {
            if (this.insideEvent) {
                throw new SAXException("Elements event must not be nested.");
            }
            this.insideEvent = true;
            this.attributeName = attr.getValue(ATTRIBUTE_ATTR);
            this.elementName = attr.getValue(ELEMENT_ATTR);
            if (this.attributeName == null && this.elementName == null) {
                throw new SAXException("Element event must have one of attributes attribute and element.");
            }
        } else if (this.insideEvent) {
            this.attrStack.push(new AttributesImpl(attr));
            if (this.elementName != null && name.equals(this.elementName)) {
                this.startTextRecording();
            } else {
                this.startRecording();
            }
        } else {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (uri.equals(NAMESPACE_URI) && name.equals(EVENT_ELEM)) {
            this.attributeName = null;
            this.elementName = null;
            this.insideEvent = false;
        } else if (this.insideEvent) {
            int index;
            String link;
            AttributesImpl attr = (AttributesImpl)this.attrStack.pop();
            if (this.attributeName != null && (link = attr.getValue(index = attr.getIndex(this.attributeName))) != null) {
                CopletInstanceData cid = this.getCopletInstanceData();
                LinkService linkService = this.getPortalService().getComponentManager().getLinkService();
                CopletLinkEvent event = new CopletLinkEvent(cid, link);
                String eventLink = linkService.getLinkURI(event);
                attr.setValue(index, eventLink);
            }
            String eventLink = null;
            DocumentFragment fragment = null;
            if (this.elementName != null && name.equals(this.elementName)) {
                String link2 = this.endTextRecording();
                CopletInstanceData cid = this.getCopletInstanceData();
                LinkService linkService = this.getPortalService().getComponentManager().getLinkService();
                CopletLinkEvent event = new CopletLinkEvent(cid, link2);
                eventLink = linkService.getLinkURI(event);
            } else {
                fragment = this.endRecording();
            }
            super.startElement(uri, name, raw, (Attributes)attr);
            if (eventLink != null) {
                super.characters(eventLink.toCharArray(), 0, eventLink.length());
            } else if (fragment != null) {
                super.sendEvents((Node)fragment);
            }
            super.endElement(uri, name, raw);
        } else {
            super.endElement(uri, name, raw);
        }
    }
}

