/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class Err {
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int FUNCTION = 3;
    public static final int VALUE = 4;
    public static final int VARIABLE = 5;
    public static final int GENERAL = 6;
    public static final int URI = 7;

    public static String wrap(CharSequence charSequence) {
        return Err.wrap(charSequence, 6);
    }

    public static String wrap(CharSequence charSequence, int n) {
        if (charSequence == null) {
            return "(NULL)";
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(40);
        int n2 = charSequence.length();
        block12: for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\n': {
                    fastStringBuffer.append("\\n");
                    continue block12;
                }
                case '\t': {
                    fastStringBuffer.append("\\t");
                    continue block12;
                }
                case '\r': {
                    fastStringBuffer.append("\\r");
                    continue block12;
                }
                default: {
                    if (c < ' ' || c > '\u00ff') {
                        fastStringBuffer.append("\\u");
                        String string = Integer.toHexString(c);
                        while (string.length() < 4) {
                            string = "0" + string;
                        }
                        fastStringBuffer.append(string);
                        continue block12;
                    }
                    fastStringBuffer.append(c);
                }
            }
        }
        String string = n2 > 30 ? (n == 7 ? "..." + fastStringBuffer.toString().substring(n2 - 30) : fastStringBuffer.toString().substring(0, 30) + "...") : fastStringBuffer.toString();
        switch (n) {
            case 1: {
                return "<" + string + ">";
            }
            case 2: {
                return "@" + string;
            }
            case 3: {
                return string + "()";
            }
            case 5: {
                return "$" + string;
            }
            case 4: {
                return "\"" + string + "\"";
            }
        }
        return "{" + string + "}";
    }

    public static CharSequence depict(Item item) {
        if (item instanceof AtomicValue) {
            CharSequence charSequence = item.getStringValueCS();
            if (item instanceof StringValue) {
                return '\"' + ((Object)Err.truncate30(charSequence)).toString() + '\"';
            }
            return Err.truncate30(charSequence);
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "<" + nodeInfo.getDisplayName() + "/>";
            }
            case 2: {
                return "@" + nodeInfo.getDisplayName();
            }
            case 3: {
                return "text(\"" + Err.truncate30(nodeInfo.getStringValue()) + "\")";
            }
            case 8: {
                return "<!--" + Err.truncate30(nodeInfo.getStringValue()) + "-->";
            }
            case 7: {
                return "<?" + nodeInfo.getDisplayName() + "?>";
            }
            case 13: {
                String string = nodeInfo.getLocalPart();
                return "xmlns" + (string.equals("") ? "" : ":" + string) + "=\"" + nodeInfo.getStringValue() + '\"';
            }
        }
        return "";
    }

    private static CharSequence truncate30(CharSequence charSequence) {
        if (charSequence.length() <= 30) {
            return Whitespace.collapseWhitespace(charSequence);
        }
        return ((Object)Whitespace.collapseWhitespace(charSequence.subSequence(0, 30))).toString() + "...";
    }
}

