/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.functions.Nilled;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;

public class ContentTypeTest
extends NodeTest {
    private int kind;
    private SchemaType schemaType;
    private int requiredType;
    private Configuration config;
    private boolean nillable = false;
    private boolean matchDTDTypes = false;

    public ContentTypeTest(int n, SchemaType schemaType, Configuration configuration) {
        this.kind = n;
        this.schemaType = schemaType;
        this.requiredType = schemaType.getFingerprint();
        if (this.requiredType == -1) {
            this.requiredType = 630;
        }
        this.config = configuration;
    }

    public void setNillable(boolean bl) {
        this.nillable = bl;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setMatchDTDTypes(boolean bl) {
        this.matchDTDTypes = bl;
    }

    public boolean matchesDTDTypes() {
        return this.matchDTDTypes;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public ItemType getSuperType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.makeNodeKindTest(this.kind);
    }

    public boolean matches(int n, int n2, int n3) {
        if (this.kind != n) {
            return false;
        }
        return this.matchesAnnotation(n3);
    }

    public boolean matches(TinyTree tinyTree, int n) {
        if (this.kind != tinyTree.getNodeKind(n)) {
            return false;
        }
        return this.matchesAnnotation(tinyTree.getTypeAnnotation(n)) && (this.nillable || !tinyTree.isNilled(n));
    }

    public boolean matches(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == this.kind && this.matchesAnnotation(nodeInfo.getTypeAnnotation()) && (this.nillable || !Nilled.isNilled(nodeInfo));
    }

    private boolean matchesAnnotation(int n) {
        if (this.requiredType == 572) {
            return true;
        }
        if (n == -1) {
            int n2 = n = this.kind == 2 ? 631 : 630;
        }
        if (this.matchDTDTypes) {
            n &= 0xFFFFF;
        } else if ((n & 0x40000000) != 0) {
            return this.requiredType == 631;
        }
        if (n == this.requiredType) {
            return true;
        }
        try {
            SchemaType schemaType = this.config.getSchemaType(n & 0xFFFFF).getBaseType();
            if (schemaType == null) {
                return false;
            }
            ContentTypeTest contentTypeTest = new ContentTypeTest(this.kind, schemaType, this.config);
            return this.config.getTypeHierarchy().isSubType(contentTypeTest, this);
        }
        catch (UnresolvedReferenceException unresolvedReferenceException) {
            throw new IllegalStateException(unresolvedReferenceException.getMessage());
        }
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return this.kind;
    }

    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    public SchemaType getContentType() {
        return this.schemaType;
    }

    public AtomicType getAtomizedItemType() {
        SchemaType schemaType = this.config.getSchemaType(this.requiredType);
        if (schemaType.isAtomicType()) {
            return (AtomicType)schemaType;
        }
        if (schemaType instanceof ListType) {
            SimpleType simpleType = ((ListType)schemaType).getItemType();
            if (simpleType.isAtomicType()) {
                return (AtomicType)simpleType;
            }
        } else if (schemaType instanceof ComplexType && ((ComplexType)schemaType).isSimpleContent()) {
            SimpleType simpleType;
            SimpleType simpleType2 = ((ComplexType)schemaType).getSimpleContentType();
            if (simpleType2.isAtomicType()) {
                return (AtomicType)simpleType2;
            }
            if (simpleType2 instanceof ListType && (simpleType = ((ListType)simpleType2).getItemType()).isAtomicType()) {
                return (AtomicType)simpleType;
            }
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public String toString() {
        return (this.kind == 1 ? "element(*, " : "attribute(*, ") + this.schemaType.getDescription() + ')';
    }

    public int hashCode() {
        return this.kind << 20 ^ this.requiredType;
    }

    public boolean equals(Object object) {
        return object instanceof ContentTypeTest && ((ContentTypeTest)object).kind == this.kind && ((ContentTypeTest)object).schemaType == this.schemaType && ((ContentTypeTest)object).requiredType == this.requiredType && ((ContentTypeTest)object).nillable == this.nillable && ((ContentTypeTest)object).matchDTDTypes == this.matchDTDTypes;
    }
}

