/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;

public class XSLPreserveSpace
extends StyleElement {
    private String elements;

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "elements") {
                this.elements = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.elements == null) {
            this.reportAbsence("elements");
            this.elements = "*";
        }
    }

    public void validate() throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    public Expression compile(Executable executable) throws XPathException {
        Boolean bl = this.getFingerprint() == 172;
        Mode mode = this.getPrincipalStylesheet().getStripperRules();
        StringTokenizer stringTokenizer = new StringTokenizer(this.elements);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string;
            String string2;
            NodeTest nodeTest;
            String string3 = stringTokenizer.nextToken();
            NodeTestPattern nodeTestPattern = new NodeTestPattern();
            nodeTestPattern.setOriginalText(string3);
            nodeTestPattern.setSystemId(this.getSystemId());
            nodeTestPattern.setLineNumber(this.getLineNumber());
            if (string3.equals("*")) {
                nodeTest = AnyNodeTest.getInstance();
                nodeTestPattern.setNodeTest(nodeTest);
                mode.addRule(nodeTestPattern, bl, this.getPrecedence(), -0.5);
                continue;
            }
            if (string3.endsWith(":*")) {
                if (string3.length() == 2) {
                    this.compileError("No prefix before ':*'");
                }
                string2 = string3.substring(0, string3.length() - 2);
                string = this.getURIForPrefix(string2, false);
                nodeTest = new NamespaceTest(this.getTargetNamePool(), 1, string);
                nodeTestPattern.setNodeTest(nodeTest);
                mode.addRule(nodeTestPattern, bl, this.getPrecedence(), -0.25);
                continue;
            }
            if (string3.startsWith("*:")) {
                if (string3.length() == 2) {
                    this.compileError("No local name after '*:'");
                }
                string2 = string3.substring(2);
                nodeTest = new LocalNameTest(this.getTargetNamePool(), 1, string2);
                nodeTestPattern.setNodeTest(nodeTest);
                mode.addRule(nodeTestPattern, bl, this.getPrecedence(), -0.25);
                continue;
            }
            string = null;
            String string4 = null;
            try {
                object = this.getConfiguration().getNameChecker().getQNameParts(string3);
                string2 = object[0];
                if (object[0].equals("")) {
                    string4 = this.getDefaultXPathNamespace();
                } else {
                    string4 = this.getURIForPrefix(string2, false);
                    if (string4 == null) {
                        this.undeclaredNamespaceError(string2, "XTSE0280");
                        return null;
                    }
                }
                string = object[1];
            }
            catch (QNameException qNameException) {
                this.compileError("Element name " + string3 + " is not a valid QName", "XTSE0280");
                return null;
            }
            object = this.getTargetNamePool();
            int n = ((NamePool)object).allocate("", string4, string);
            nodeTest = new NameTest(1, n, this.getNamePool());
            nodeTestPattern.setNodeTest(nodeTest);
            mode.addRule(nodeTestPattern, bl, this.getPrecedence(), 0.0);
        }
        return null;
    }
}

