/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.grammar;

import java.io.Serializable;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.symbol.Nonterminal;
import net.sourceforge.chaperon.model.symbol.SymbolList;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import net.sourceforge.chaperon.model.symbol.Terminal;

public class Production
implements Serializable,
Cloneable {
    private Nonterminal ntsymbol = new Nonterminal("noname");
    private SymbolList definition = new SymbolList();
    private Terminal precedence = null;
    private String location = null;

    public Production() {
    }

    public Production(Nonterminal ntsymbol) {
        this.setSymbol(ntsymbol);
    }

    public Production(Nonterminal ntsymbol, SymbolList definition) {
        this.setSymbol(ntsymbol);
        this.setDefinition(definition);
    }

    public void setSymbol(Nonterminal ntsymbol) {
        if (ntsymbol == null) {
            throw new NullPointerException();
        }
        this.ntsymbol = ntsymbol;
    }

    public void setSymbolName(String name) {
        this.ntsymbol = name != null && name.length() > 0 ? new Nonterminal(name) : null;
    }

    public Nonterminal getSymbol() {
        return this.ntsymbol;
    }

    public String getSymbolName() {
        if (this.ntsymbol != null) {
            return this.ntsymbol.getName();
        }
        return null;
    }

    public void setDefinition(SymbolList definition) {
        if (definition == null) {
            throw new NullPointerException();
        }
        this.definition = definition;
    }

    public SymbolList getDefinition() {
        return this.definition;
    }

    public int getLength() {
        return this.definition.getSymbolCount();
    }

    public void setPrecedence(Terminal tsymbol) {
        this.precedence = tsymbol;
    }

    public void setPrecedenceAsString(String name) {
        this.precedence = name != null && name.length() > 0 ? new Terminal(name) : null;
    }

    public Terminal getPrecedence() {
        return this.precedence;
    }

    public String getPrecedenceAsString() {
        if (this.precedence != null) {
            return this.precedence.getName();
        }
        return null;
    }

    public boolean hasPrecedence() {
        return this.precedence != null;
    }

    public SymbolSet getSymbols() {
        SymbolSet set = new SymbolSet();
        set.addSymbol(this.ntsymbol);
        set.addSymbol(this.definition);
        if (this.precedence != null) {
            set.addSymbol(this.precedence);
        }
        return set;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.ntsymbol == null) {
            violations.addViolation("No symbol is for the left side defined", this.location);
        }
        return violations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Production) {
            Production production = (Production)o;
            if (this.precedence != null) {
                return this.ntsymbol.equals(production.ntsymbol) && this.definition.equals(production.definition) && this.precedence.equals(production.precedence);
            }
            return this.ntsymbol.equals(production.ntsymbol) && this.definition.equals(production.definition) && production.precedence == null;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.ntsymbol + " := ");
        int j = 0;
        while (j < this.definition.getSymbolCount()) {
            buffer.append(this.definition.getSymbol(j) + " ");
            ++j;
        }
        if (this.hasPrecedence()) {
            buffer.append("[precedence=" + this.getPrecedence() + "]");
        }
        return buffer.toString();
    }

    public Object clone() {
        Production clone = new Production();
        clone.ntsymbol = this.ntsymbol;
        clone.definition = (SymbolList)this.definition.clone();
        clone.precedence = this.precedence;
        clone.location = this.location;
        return clone;
    }
}

