/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;
import org.mortbay.util.URLResource;

class FileResource
extends URLResource {
    private static boolean __checkAliases = "true".equalsIgnoreCase(System.getProperty("org.mortbay.util.FileResource.checkAliases", "true"));
    private File _file;
    private transient URL _alias = null;
    private transient boolean _aliasChecked = false;

    FileResource(URL url) throws IOException {
        super(url, url.openConnection());
        Permission perm = this._connection.getPermission();
        this._file = new File(perm == null ? url.getFile() : perm.getName());
    }

    FileResource(URL url, URLConnection connection, File file) {
        super(url, connection);
        this._file = file;
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        if (!this.isDirectory()) {
            return super.addPath(path);
        }
        if ((path = URI.canonicalPath(path)).startsWith("/")) {
            path = path.substring(1);
        }
        File newFile = new File(this._file, path);
        if (path.length() > 0 && !path.endsWith("/") && newFile.isDirectory()) {
            path = path + "/";
        }
        FileResource r = new FileResource(new URL(this._url, path), null, newFile);
        return r;
    }

    public URL getAlias() {
        if (__checkAliases && !this._aliasChecked) {
            try {
                String abs = this._file.getAbsolutePath();
                String can = this._file.getCanonicalPath();
                if (!abs.equals(can)) {
                    this._alias = Resource.newResource(can).getURL();
                }
                if (this._alias != null && Code.debug()) {
                    Code.debug((Object)"ALIAS abs=", (Object)abs);
                    Code.debug((Object)"ALIAS can=", (Object)can);
                }
            }
            catch (IOException e) {
                Code.ignore(e);
            }
        }
        return this._alias;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public long length() {
        return this._file.length();
    }

    public String getName() {
        return this._file.getAbsolutePath();
    }

    public File getFile() {
        return this._file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this._file);
    }

    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    public String[] list() {
        String[] list = this._file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this._file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = list[n] + "/";
        }
        return list;
    }

    public String encode(String uri) {
        return uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f._file == this._file || null != this._file && this._file.equals(f._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    static {
        if (__checkAliases) {
            Log.event("Checking Resource aliases");
        }
    }
}

