/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class LocationTrackingDebugger
implements Debugger {
    private static final LocationUtils.LocationFinder rhinoLocFinder = new LocationUtils.LocationFinder(){

        public Location getLocation(Object obj, String description) {
            if (obj instanceof EcmaError) {
                EcmaError ex = (EcmaError)obj;
                if (ex.getSourceName() != null) {
                    return new LocationImpl(ex.getName(), ex.getSourceName(), ex.getLineNumber(), ex.getColumnNumber());
                }
                return Location.UNKNOWN;
            }
            if (obj instanceof JavaScriptException) {
                JavaScriptException ex = (JavaScriptException)obj;
                if (ex.sourceName() != null) {
                    return new LocationImpl(description, ex.sourceName(), ex.lineNumber(), -1);
                }
                return Location.UNKNOWN;
            }
            return null;
        }
    };
    protected List locations;
    protected Throwable throwable;

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, StringBuffer source) {
    }

    public DebugFrame enterFrame(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, DebuggableScript fnOrScript) {
        return new StackTrackingFrame(fnOrScript);
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        return new StackTrackingFrame(fnOrScript);
    }

    public Exception getException(String description, Exception originalException) throws ProcessingException {
        if (this.throwable == null || this.locations == null) {
            return originalException;
        }
        Throwable cause = ExceptionUtils.getCause((Throwable)this.throwable);
        if (cause != null) {
            this.throwable = cause;
        }
        return ProcessingException.throwLocated(description, this.throwable, this.locations);
    }

    static {
        ExceptionUtils.addCauseMethodName((String)"getWrappedException");
        LocationUtils.addFinder(rhinoLocFinder);
    }

    private class StackTrackingFrame
    implements DebugFrame {
        DebuggableScript script;
        int line;

        public StackTrackingFrame(DebuggableScript script) {
            this.script = script;
        }

        public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        }

        public void onLineChange(Context cx, int lineNumber, boolean breakpoint) {
            this.line = lineNumber;
        }

        public void onLineChange(Context cx, int lineNumber) {
            this.line = lineNumber;
        }

        public void onExceptionThrown(Context cx, Throwable ex) {
            LocationTrackingDebugger.this.throwable = ex;
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            if (byThrow) {
                String name = null;
                if (LocationTrackingDebugger.this.locations == null) {
                    LocationTrackingDebugger.this.locations = new ArrayList(1);
                }
                LocationTrackingDebugger.this.locations.add(new LocationImpl(name, this.script.getSourceName(), this.line, -1));
            } else if (LocationTrackingDebugger.this.locations != null) {
                LocationTrackingDebugger.this.locations = null;
            }
        }
    }
}

