/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.ErrorMessage;
import net.sf.pizzacompiler.compiler.FileSourceReader;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Position;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.compiler.WarningMessage;

public class Report
implements Constants {
    static final int MAX_ERRORS = 100;
    static final int noPos = 0;
    private static PrintStream _out;
    private static Name _sourceName;
    static boolean ignoreErrors;
    private static Set _errors;
    private static Set _warnings;
    private static int lastPos;
    private static int lastLine;
    private static int lineEnd;
    static final byte LF = 10;
    static final byte FF = 12;
    static final byte CR = 13;

    static void init() {
        _out = null;
        Report.useSource(Name.fromString("<input>"));
        ignoreErrors = false;
        _errors = new HashSet();
        _warnings = new HashSet();
    }

    static Name useSource(Name name) {
        Name name2 = _sourceName;
        _sourceName = name;
        return name2;
    }

    static void prompt() {
        if (Switches.promptOnError) {
            Report.getOut().println("R)esume, A)bort>");
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new InternalError("user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new InternalError("input read error");
            }
        }
    }

    private static void printErrLine(Position position) {
        Report.getOut().println(Report.makeSourceDisplay(_sourceName.toString(), position));
    }

    public static String makeSourceDisplay(String string, Position position) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            byte[] byArray = new FileSourceReader().readAll(string);
            for (lastLine = 0; n < byArray.length && lastLine < position.getLine(); ++lastLine) {
                lastPos = n;
                while (n < byArray.length && byArray[n] != 13 && byArray[n] != 10 && byArray[n] != 12) {
                    ++n;
                }
                lineEnd = n;
                if (n < byArray.length) {
                    ++n;
                }
                if (n >= byArray.length || byArray[n - 1] != 13 || byArray[n] != 10) continue;
                ++n;
            }
            stringBuffer.append(new String(byArray, 0, lastPos, lineEnd - lastPos));
            stringBuffer.append('\n');
            byte[] byArray2 = new byte[position.getColumn()];
            for (int i = 1; i < position.getColumn(); ++i) {
                byArray2[i - 1] = 32;
            }
            byArray2[position.getColumn() - 1] = 94;
            stringBuffer.append(new String(byArray2, 0));
        }
        catch (IOException iOException) {
            stringBuffer.append("(source unavailable)");
        }
        return stringBuffer.toString();
    }

    private static void printError(ErrorMessage errorMessage) {
        if (!Switches.errorsPossible) {
            Report.getOut().println("Suspicious error message -- ");
            Report.getOut().println("there might be something wrong with the Pizza->Java translation.");
            Report.inviteBugReport();
        }
        Report.getOut().println(errorMessage);
        if (errorMessage.getPosition().isValid()) {
            Report.printErrLine(errorMessage.getPosition());
        }
    }

    static void error(int n, String string) {
        ErrorMessage errorMessage;
        if (!ignoreErrors && Report.getNrErrors() < 100 && !_errors.contains(errorMessage = new ErrorMessage(_sourceName.toString(), Position.makePosition(n), string))) {
            _errors.add(errorMessage);
            Report.printError(errorMessage);
            Report.prompt();
        }
    }

    static void warning(int n, String string) {
        if (!ignoreErrors && Switches.errorsPossible && Report.getNrWarnings() < 100 && !Switches.nowarn) {
            WarningMessage warningMessage = new WarningMessage(_sourceName.toString(), Position.makePosition(n), string);
            Report.printError(warningMessage);
            _warnings.add(warningMessage);
        }
    }

    static void message(String string) {
        Report.getOut().println(string);
    }

    static int getNrErrors() {
        return _errors.size();
    }

    static int getNrWarnings() {
        return _warnings.size();
    }

    public static Set getErrorsAndWarnings() {
        if (_warnings == null) {
            Report.init();
        }
        HashSet hashSet = new HashSet(_warnings);
        hashSet.addAll(_errors);
        return hashSet;
    }

    static void inviteBugReport() {
        Report.getOut().println("Please file a bug report at Sourceforge.net:");
        Report.getOut().println("http://sourceforge.net/tracker/?group_id=31504&atid=402238\n\n   Thank you.\n");
    }

    private static PrintStream getOut() {
        return _out == null ? System.out : _out;
    }

    static void setOut(PrintStream printStream) {
        _out = printStream;
    }

    static {
        lastPos = 0;
        lastLine = 0;
        lineEnd = 0;
    }
}

