/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.pizzadoc;

import java.io.IOException;
import java.io.PrintStream;
import net.sf.pizzacompiler.compiler.AST;
import net.sf.pizzacompiler.compiler.ClassSymbol;
import net.sf.pizzacompiler.compiler.FunSymbol;
import net.sf.pizzacompiler.lang.Pair;
import net.sf.pizzacompiler.pizzadoc.DocClassSymbol;
import net.sf.pizzacompiler.pizzadoc.DocComment$$closures;
import net.sf.pizzacompiler.pizzadoc.DocFunSymbol;
import net.sf.pizzacompiler.pizzadoc.DocSwitches;
import net.sf.pizzacompiler.util.Vector;

class DocComment {
    static final byte LF = 10;
    static final byte FF = 12;
    static final byte CR = 13;
    static final byte SUB = 26;
    private static final String[] TAGS = new String[]{"", "@deprecated", "@param", "@return", "@see", "@author", "@version", "@exception", "@since"};
    private static final int NoTag = 0;
    private static final int DeprecatedTag = 1;
    private static final int ParamTag = 2;
    private static final int ReturnTag = 3;
    private static final int SeeTag = 4;
    private static final int AuthorTag = 5;
    private static final int VersionTag = 6;
    private static final int ExceptionTag = 7;
    private static final int SinceTag = 8;
    int pos;
    String text = null;
    String deprecated = null;
    Vector param;
    String returns = null;
    Vector see;
    Vector author;
    Vector exception;
    String version = null;
    String since = null;

    DocComment(int n, byte[] byArray, int n2, int n3) {
        this.pos = n;
        this.param = new Vector(new DocComment$$closures(this, 0, null), null);
        this.exception = new Vector(new DocComment$$closures(this, 0, null), null);
        this.see = new Vector(new DocComment$$closures(this, 1, null), null);
        this.author = new Vector(new DocComment$$closures(this, 1, null), null);
        this.scan(byArray, n2 + 1, n3 - 1);
    }

    private Pair[] allocPair(int n) {
        return new Pair[n];
    }

    private String[] allocString(int n) {
        return new String[n];
    }

    private void scan(byte[] byArray, int n, int n2) {
        int n3 = n + 1;
        byte by = byArray[n3];
        int n4 = 0;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n + n2 - 1 && (by == 32 || by == 9 || by == 42)) {
            by = byArray[++n3];
        }
        while (n3 < n + n2 - 1) {
            switch (by) {
                case 10: 
                case 13: {
                    stringBuffer.append((char)by);
                    by = byArray[++n3];
                    if (by == 10) {
                        stringBuffer.append((char)by);
                        by = byArray[++n3];
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while (by == 32 || by == 9) {
                        stringBuffer2.append((char)by);
                        by = byArray[++n3];
                    }
                    if (by == 42) {
                        while (by == 42) {
                            by = byArray[++n3];
                        }
                    } else {
                        stringBuffer.append((Object)stringBuffer2);
                    }
                    bl = true;
                    if (by != 64) break;
                }
                case 64: {
                    int n5 = n3;
                    if (bl) {
                        bl = false;
                        String string = "@";
                        boolean bl2 = false;
                        block12: while (!bl2) {
                            by = byArray[++n3];
                            switch (by) {
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: 
                                case 103: 
                                case 104: 
                                case 105: 
                                case 106: 
                                case 107: 
                                case 108: 
                                case 109: 
                                case 110: 
                                case 111: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 119: 
                                case 120: 
                                case 121: 
                                case 122: {
                                    string = String.valueOf(string).concat(String.valueOf((char)by));
                                    continue block12;
                                }
                            }
                            bl2 = true;
                        }
                        int n6 = 0;
                        for (int i = 1; i < TAGS.length; ++i) {
                            if (!TAGS[i].equals(string)) continue;
                            n6 = i;
                        }
                        if (n6 != 0) {
                            this.storeText(n4, stringBuffer);
                            stringBuffer = new StringBuffer();
                            n4 = n6;
                            while ((by = byArray[++n3]) == 32 || by == 9) {
                            }
                            break;
                        }
                    }
                    stringBuffer.append('@');
                    n3 = n5 + 1;
                    by = byArray[n3];
                    break;
                }
                case 9: 
                case 32: {
                    stringBuffer.append((char)by);
                    by = byArray[++n3];
                    break;
                }
                default: {
                    stringBuffer.append((char)by);
                    by = byArray[++n3];
                    bl = false;
                }
            }
        }
        this.storeText(n4, stringBuffer);
    }

    private void storeText(int n, StringBuffer stringBuffer) {
        while (stringBuffer.length() > 1 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() > 1 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() > 1 && stringBuffer.charAt(stringBuffer.length() - 1) == '\r') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        switch (n) {
            case 0: {
                this.addText(stringBuffer.toString());
                break;
            }
            case 1: {
                this.deprecated = stringBuffer.toString();
                break;
            }
            case 2: {
                String string = stringBuffer.toString();
                String string2 = "";
                int n2 = string.indexOf(" ");
                int n3 = string.indexOf("\t");
                if (n3 > 0 && n3 < n2) {
                    n2 = n3;
                }
                if (n2 > 0) {
                    string = stringBuffer.toString().substring(0, n2);
                    string2 = stringBuffer.toString().substring(n2 + 1, stringBuffer.length());
                }
                this.addParam(string, string2);
                break;
            }
            case 3: {
                this.returns = stringBuffer.toString();
                break;
            }
            case 4: {
                this.addSee(stringBuffer.toString());
                break;
            }
            case 5: {
                this.addAuthor(stringBuffer.toString());
                break;
            }
            case 6: {
                this.version = stringBuffer.toString();
                break;
            }
            case 8: {
                this.since = stringBuffer.toString();
                break;
            }
            case 7: {
                String string = stringBuffer.toString();
                String string3 = "";
                int n4 = string.indexOf(" ");
                if (n4 > 0) {
                    string = stringBuffer.toString().substring(0, n4);
                    string3 = stringBuffer.toString().substring(n4 + 1, stringBuffer.length());
                }
                this.addException(string, string3);
                break;
            }
            default: {
                System.out.println("Unknown tag ID");
            }
        }
    }

    private void addText(String string) {
        if (this.text == null) {
            this.text = "";
        }
        this.text = String.valueOf(this.text).concat(String.valueOf(string));
    }

    private void addSee(String string) {
        this.see.addElement(string);
    }

    private void addParam(String string, String string2) {
        this.param.addElement(new Pair(string, string2));
    }

    private void addException(String string, String string2) {
        this.exception.addElement(new Pair(string, string2));
    }

    private void addAuthor(String string) {
        this.author.addElement(string);
    }

    public String toString() {
        String string = "";
        if (this.text != null) {
            string = String.valueOf(String.valueOf(string).concat(String.valueOf(this.text))).concat(String.valueOf(" "));
        }
        if (this.returns != null) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("returns: "))).concat(String.valueOf(this.returns))).concat(String.valueOf(" "));
        }
        if (this.param.size() != 0) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("parameter: "))).concat(String.valueOf(this.param))).concat(String.valueOf(" "));
        }
        if (this.exception.size() != 0) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("throws: "))).concat(String.valueOf(this.exception))).concat(String.valueOf(" "));
        }
        if (this.author.size() != 0) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("author(s): "))).concat(String.valueOf(this.author))).concat(String.valueOf(" "));
        }
        if (this.version != null) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("version: "))).concat(String.valueOf(this.version))).concat(String.valueOf(" "));
        }
        if (this.since != null) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("since: "))).concat(String.valueOf(this.since))).concat(String.valueOf(" "));
        }
        if (this.see.size() != 0) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("see also: "))).concat(String.valueOf(this.see))).concat(String.valueOf(" "));
        }
        if (this.deprecated != null) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("DEPRECATED: "))).concat(String.valueOf(this.deprecated))).concat(String.valueOf(" "));
        }
        return string;
    }

    boolean isDeprecated() {
        return this.deprecated != null;
    }

    private String getLinkText(String string, String string2) {
        if (string2.startsWith("<a href")) {
            return string2;
        }
        int n = string2.indexOf("#");
        if (n == 0) {
            return String.valueOf(String.valueOf(String.valueOf(String.valueOf("<a href=\"").concat(String.valueOf(string2))).concat(String.valueOf("\">"))).concat(String.valueOf(string2.substring(1, string2.length())))).concat(String.valueOf("</a>"));
        }
        String string3 = string2;
        n = string2.indexOf(".");
        if (n < 0) {
            string2 = String.valueOf(String.valueOf(string).concat(String.valueOf("."))).concat(String.valueOf(string2));
        }
        if ((n = string2.indexOf("#")) > 0) {
            string3 = string2.substring(n + 1, string2.length());
            string2 = String.valueOf(String.valueOf(string2.substring(0, n)).concat(String.valueOf(".html#"))).concat(String.valueOf(string3));
        } else {
            string2 = String.valueOf(string2).concat(String.valueOf(".html"));
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("<a href=\"").concat(String.valueOf(string2))).concat(String.valueOf("\">"))).concat(String.valueOf(string3))).concat(String.valueOf("</a>"));
    }

    void toHtml(PrintStream printStream, String string, AST aST) throws IOException {
        int n;
        printStream.println("<dl>");
        if (this.deprecated != null && DocSwitches.pizzadoc_deprecatedinfo) {
            printStream.println("  <dd> <b>Note: deprecated!</b>");
            printStream.println(String.valueOf(String.valueOf("    <i>").concat(String.valueOf(this.deprecated))).concat(String.valueOf("</i><p></dd>")));
        }
        if (this.text != null) {
            printStream.println(String.valueOf(String.valueOf("  <dd> ").concat(String.valueOf(this.text))).concat(String.valueOf("<p></dd>")));
        }
        printStream.println("  <dd><dl><dt></dt>");
        if ((aST instanceof AST.ClassDef || aST instanceof AST.FunDef) && this.param.size() != 0) {
            printStream.println("    <dt> <b>Parameters:</b></dt>");
            for (n = 0; n < this.param.size(); ++n) {
                printStream.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("      <dd><b>").concat(String.valueOf((String)((Pair)this.param.elementAt((int)n)).fst))).concat(String.valueOf("</b> - "))).concat(String.valueOf((String)((Pair)this.param.elementAt((int)n)).snd))).concat(String.valueOf("</dd>")));
            }
        }
        if (aST instanceof AST.FunDef) {
            FunSymbol funSymbol;
            if (this.returns != null) {
                printStream.println("    <dt> <b>Returns:</b></dt>");
                printStream.println(String.valueOf(String.valueOf("      <dd>").concat(String.valueOf(this.returns))).concat(String.valueOf("</dd>")));
            }
            if (this.exception.size() != 0) {
                printStream.println("    <dt> <b>Throws:</b></dt>");
                printStream.println("    <dd><dl>");
                for (n = 0; n < this.exception.size(); ++n) {
                    Pair pair = (Pair)this.exception.elementAt(n);
                    printStream.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("      <dt><b>").concat(String.valueOf(this.getLinkText(string, (String)pair.fst)))).concat(String.valueOf("</b> -"))).concat(String.valueOf((String)pair.snd))).concat(String.valueOf("</dt>")));
                }
                printStream.println("      </dl><dd>");
            }
            if ((funSymbol = ((FunSymbol)aST.symbol()).overridden()) != null) {
                printStream.println("    <dt> <b>Overrides:</b></dt>");
                printStream.println("    <dd><dl>");
                printStream.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("      <dt><b>").concat(String.valueOf(DocFunSymbol.toN(funSymbol)))).concat(String.valueOf("</b> in class "))).concat(String.valueOf(DocClassSymbol.toN((ClassSymbol)funSymbol.owner)))).concat(String.valueOf("</dt>")));
                printStream.println("      </dl></dd>");
            }
        }
        if (aST instanceof AST.ClassDef) {
            if (DocSwitches.pizzadoc_author && this.author.size() != 0) {
                printStream.println("    <dt> <b>Author:</b></dt>");
                String string2 = (String)this.author.elementAt(0);
                for (int i = 1; i < this.author.size(); ++i) {
                    string2 = String.valueOf(String.valueOf(string2).concat(String.valueOf(", "))).concat(String.valueOf((String)this.author.elementAt(i)));
                }
                printStream.println(String.valueOf(String.valueOf("      <dd> ").concat(String.valueOf(string2))).concat(String.valueOf("</dd>")));
            }
            if (DocSwitches.pizzadoc_version && this.version != null) {
                printStream.println(String.valueOf(String.valueOf("    <dt> <b>Version:</b> ").concat(String.valueOf(this.version))).concat(String.valueOf("</dt>")));
            }
            if (DocSwitches.pizzadoc_since && this.since != null) {
                printStream.println(String.valueOf(String.valueOf("    <dt> <b>Included since:</b> ").concat(String.valueOf(this.since))).concat(String.valueOf("</dt>")));
            }
        }
        if (this.see.size() != 0) {
            printStream.println("    <dt> <b>See also:</b></dt>");
            String string3 = this.getLinkText(string, (String)this.see.elementAt(0));
            for (int i = 1; i < this.see.size(); ++i) {
                string3 = String.valueOf(String.valueOf(string3).concat(String.valueOf(", "))).concat(String.valueOf(this.getLinkText(string, (String)this.see.elementAt(i))));
            }
            printStream.println(String.valueOf(String.valueOf("      <dd> ").concat(String.valueOf(string3))).concat(String.valueOf("</dd>")));
        }
        printStream.println("  </dl></dd>");
        printStream.println("</dl>");
    }

    String toShortComment() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.deprecated != null && DocSwitches.pizzadoc_deprecatedinfo) {
            stringBuffer.append("<b>Deprecated!</b> ");
        }
        if (this.text != null) {
            int n = 96;
            int n2 = this.text.indexOf(". ");
            if (n2 < n && n2 > 1) {
                n = n2 - 1;
            }
            if ((n2 = this.text.indexOf("<pre>")) < n && n2 > 1) {
                n = n2 - 1;
            }
            if ((n2 = this.text.indexOf("<p>")) < n && n2 > 1) {
                n = n2 - 1;
            }
            if ((n2 = this.text.indexOf("<br>")) < n && n2 > 1) {
                n = n2 - 1;
            }
            if ((n2 = this.text.indexOf(".13")) < n && n2 > 1) {
                n = n2;
            }
            if ((n2 = this.text.indexOf(".10")) < n && n2 > 1) {
                n = n2;
            }
            if ((n2 = this.text.indexOf(".\t")) < n && n2 > 1) {
                n = n2;
            }
            if (n > 95) {
                if (this.text.length() > 95) {
                    n = this.text.substring(0, 95).lastIndexOf(32);
                    if (n < 1) {
                        n = 95;
                    }
                } else {
                    n = this.text.length() - 1;
                }
            }
            stringBuffer.append(this.text.substring(0, n + 1));
        }
        return stringBuffer.toString();
    }

    /* synthetic */ Pair[] $closure$net$sf$pizzacompiler$pizzadoc$DocComment$0d(int n, Object[] objectArray) {
        return this.allocPair(n);
    }

    /* synthetic */ String[] $closure$net$sf$pizzacompiler$pizzadoc$DocComment$1d(int n, Object[] objectArray) {
        return this.allocString(n);
    }
}

