/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class AWTFontFamily
implements GVTFontFamily {
    protected GVTFontFace fontFace;
    protected Font font;

    public AWTFontFamily(GVTFontFace gVTFontFace) {
        this.fontFace = gVTFontFace;
    }

    public AWTFontFamily(String string) {
        this(new GVTFontFace(string));
    }

    public AWTFontFamily(GVTFontFace gVTFontFace, Font font) {
        this.fontFace = gVTFontFace;
        this.font = font;
    }

    public String getFamilyName() {
        return this.fontFace.getFamilyName();
    }

    public GVTFontFace getFontFace() {
        return this.fontFace;
    }

    public GVTFont deriveFont(float f, AttributedCharacterIterator attributedCharacterIterator) {
        if (this.font != null) {
            return new AWTGVTFont(this.font, f);
        }
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>(attributedCharacterIterator.getAttributes());
        hashMap.put(TextAttribute.SIZE, new Float(f));
        hashMap.put(TextAttribute.FAMILY, this.fontFace.getFamilyName());
        hashMap.remove(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
        return new AWTGVTFont(hashMap);
    }
}

