/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource.ids;

import java.math.BigDecimal;
import org.apache.avalon.excalibur.datasource.ids.AbstractDataSourceIdGenerator;
import org.apache.avalon.excalibur.datasource.ids.IdException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public abstract class AbstractDataSourceBlockIdGenerator
extends AbstractDataSourceIdGenerator {
    private BigDecimal m_firstBigDecimal;
    private long m_firstLong;
    private int m_blockSize;
    private int m_allocated;

    protected abstract BigDecimal allocateBigDecimalIdBlock(int var1) throws IdException;

    protected abstract long allocateLongIdBlock(int var1) throws IdException;

    protected BigDecimal getNextBigDecimalIdInner() throws IdException {
        if (this.m_allocated >= this.m_blockSize) {
            try {
                this.m_firstBigDecimal = this.allocateBigDecimalIdBlock(this.m_blockSize);
                this.m_allocated = 0;
            }
            catch (IdException e) {
                this.m_allocated = Integer.MAX_VALUE;
                throw e;
            }
        }
        BigDecimal id = this.m_firstBigDecimal.add(new BigDecimal((double)this.m_allocated));
        ++this.m_allocated;
        return id;
    }

    protected long getNextLongIdInner() throws IdException {
        long id;
        if (this.m_allocated >= this.m_blockSize) {
            try {
                this.m_firstLong = this.allocateLongIdBlock(this.m_blockSize);
                this.m_allocated = 0;
            }
            catch (IdException e) {
                this.m_allocated = Integer.MAX_VALUE;
                throw e;
            }
        }
        if ((id = this.m_firstLong + (long)this.m_allocated) < 0L) {
            String msg = "No more Ids are available, the maximum long value has been reached.";
            this.getLogger().error(msg);
            throw new IdException(msg);
        }
        ++this.m_allocated;
        return id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.m_blockSize = configuration.getAttributeAsInteger("block-size", 10);
    }

    public void initialize() throws Exception {
        super.initialize();
        this.m_allocated = Integer.MAX_VALUE;
    }
}

