/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CmdLineStatusFromXml
extends CmdLineXmlCommand {
    private SVNRevision.Number lastChangedRevision;
    private Date lastChangedDate;
    private String lastCommitAuthor;
    private SVNStatusKind textStatus;
    private SVNStatusKind repositoryTextStatus;
    private SVNStatusKind propStatus;
    private SVNStatusKind repositoryPropStatus;
    private SVNRevision.Number revision;
    private String path;
    private boolean copied;
    private boolean wcLocked;
    private boolean switched;
    private File conflictNew;
    private File conflictOld;
    private File conflictWorking;
    private String lockOwner;
    private Date lockCreationDate;
    private String lockComment;

    protected CmdLineStatusFromXml(String path) {
        this.path = path;
    }

    public File getConflictNew() {
        return this.conflictNew;
    }

    public File getConflictOld() {
        return this.conflictOld;
    }

    public File getConflictWorking() {
        return this.conflictWorking;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public boolean isWcLocked() {
        return this.wcLocked;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public File getFile() {
        return new File(this.getPath()).getAbsoluteFile();
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.lastChangedRevision;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public Date getLockCreationDate() {
        return this.lockCreationDate;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getPath() {
        return this.path;
    }

    public SVNStatusKind getPropStatus() {
        return this.propStatus;
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public SVNRevision.Number getRevision() {
        return this.revision;
    }

    public SVNStatusKind getTextStatus() {
        return this.textStatus;
    }

    protected void setConflictNew(File conflictNew) {
        this.conflictNew = conflictNew;
    }

    protected void setConflictOld(File conflictOld) {
        this.conflictOld = conflictOld;
    }

    protected void setConflictWorking(File conflictWorking) {
        this.conflictWorking = conflictWorking;
    }

    protected void setCopied(boolean copied) {
        this.copied = copied;
    }

    protected void setWcLocked(boolean wcLocked) {
        this.wcLocked = wcLocked;
    }

    protected void setSwitched(boolean switched) {
        this.switched = switched;
    }

    protected void setLastCommitAuthor(String lastCommitAuthor) {
        this.lastCommitAuthor = lastCommitAuthor;
    }

    protected void setLastChangedDate(Date lastChangedDate) {
        this.lastChangedDate = lastChangedDate;
    }

    protected void setLastChangedRevision(SVNRevision.Number lastChangedRevision) {
        this.lastChangedRevision = lastChangedRevision;
    }

    protected void setLockComment(String lockComment) {
        this.lockComment = lockComment;
    }

    protected void setLockCreationDate(Date lockCreationDate) {
        this.lockCreationDate = lockCreationDate;
    }

    protected void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void setPropStatus(SVNStatusKind propStatus) {
        this.propStatus = propStatus;
    }

    protected void setRepositoryPropStatus(SVNStatusKind repositoryPropStatus) {
        this.repositoryPropStatus = repositoryPropStatus;
    }

    protected void setRepositoryTextStatus(SVNStatusKind repositoryTextStatus) {
        this.repositoryTextStatus = repositoryTextStatus;
    }

    protected void setRevision(SVNRevision.Number revision) {
        this.revision = revision;
    }

    protected void setTextStatus(SVNStatusKind textStatus) {
        this.textStatus = textStatus;
    }

    public static CmdLineStatusFromXml[] createStatuses(byte[] cmdLineResults) throws CmdLineException {
        ArrayList<CmdLineStatusFromXml> statuses = new ArrayList<CmdLineStatusFromXml>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            InputSource source = new InputSource(new ByteArrayInputStream(cmdLineResults));
            Document doc = factory.newDocumentBuilder().parse(source);
            NodeList nodes = doc.getElementsByTagName("entry");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element reposStatusNode;
                Element lockNode;
                Node wcLockedAttr;
                Node statusEntry = nodes.item(i);
                String entryPath = statusEntry.getAttributes().getNamedItem("path").getNodeValue();
                CmdLineStatusFromXml status = new CmdLineStatusFromXml(entryPath);
                Element wcStatusNode = CmdLineStatusFromXml.getFirstNamedElement(statusEntry, "wc-status");
                if (wcStatusNode == null) {
                    throw new Exception("'wc-status' tag expected under 'entry'");
                }
                Node wcItemStatusAttr = wcStatusNode.getAttributes().getNamedItem("item");
                status.setTextStatus(SVNStatusKind.fromString(wcItemStatusAttr.getNodeValue()));
                Node wcPpropStatusAttr = wcStatusNode.getAttributes().getNamedItem("props");
                status.setPropStatus(SVNStatusKind.fromString(wcPpropStatusAttr.getNodeValue()));
                Node wcRevisionAttribute = wcStatusNode.getAttributes().getNamedItem("revision");
                if (wcRevisionAttribute != null) {
                    status.setRevision(Helper.toRevNum(wcRevisionAttribute.getNodeValue()));
                }
                status.setWcLocked((wcLockedAttr = wcStatusNode.getAttributes().getNamedItem("wc-locked")) != null && "true".equals(wcLockedAttr.getNodeValue()));
                Node copiedAttr = wcStatusNode.getAttributes().getNamedItem("copied");
                status.setCopied(copiedAttr != null && "true".equals(copiedAttr.getNodeValue()));
                Node switchedAttr = wcStatusNode.getAttributes().getNamedItem("switched");
                status.setSwitched(switchedAttr != null && "true".equals(switchedAttr.getNodeValue()));
                Element commitNode = CmdLineStatusFromXml.getFirstNamedElement(wcStatusNode, "commit");
                if (commitNode != null) {
                    Element dateNode;
                    Node commitRevisionAttribute = commitNode.getAttributes().getNamedItem("revision");
                    status.setLastChangedRevision(Helper.toRevNum(commitRevisionAttribute.getNodeValue()));
                    Element authorNode = CmdLineStatusFromXml.getFirstNamedElement(commitNode, "author");
                    if (authorNode != null) {
                        status.setLastCommitAuthor(authorNode.getFirstChild().getNodeValue());
                    }
                    if ((dateNode = CmdLineStatusFromXml.getNextNamedElement(authorNode, "date")) != null) {
                        status.setLastChangedDate(Helper.convertXMLDate(dateNode.getFirstChild().getNodeValue()));
                    }
                }
                if ((lockNode = CmdLineStatusFromXml.getNextNamedElement(commitNode, "lock")) != null) {
                    Element tokenNode = CmdLineStatusFromXml.getFirstNamedElement(lockNode, "token");
                    if (tokenNode == null) {
                        throw new Exception("'token' tag expected under 'lock'");
                    }
                    Element ownerNode = CmdLineStatusFromXml.getNextNamedElement(lockNode, "owner");
                    if (ownerNode == null) {
                        throw new Exception("'owner' tag expected under 'lock'");
                    }
                    status.setLockOwner(ownerNode.getFirstChild().getNodeValue());
                    Element lockCommentNode = CmdLineStatusFromXml.getNextNamedElement(ownerNode, "comment");
                    status.setLockComment(lockCommentNode != null ? lockCommentNode.getFirstChild().getNodeValue() : null);
                    Element lockCreatedNode = CmdLineStatusFromXml.getNextNamedElement(lockCommentNode, "created");
                    status.setLockCreationDate(Helper.convertXMLDate(lockCreatedNode != null ? lockCreatedNode.getFirstChild().getNodeValue() : null));
                }
                if ((reposStatusNode = CmdLineStatusFromXml.getNextNamedElement(wcStatusNode, "repos-status")) != null) {
                    Node reposItemStatusAttr = reposStatusNode.getAttributes().getNamedItem("item");
                    status.setRepositoryTextStatus(SVNStatusKind.fromString(reposItemStatusAttr.getNodeValue()));
                    Node reposPropStatusAttr = reposStatusNode.getAttributes().getNamedItem("props");
                    status.setRepositoryPropStatus(SVNStatusKind.fromString(reposPropStatusAttr.getNodeValue()));
                }
                statuses.add(status);
            }
        }
        catch (Exception e) {
            throw new CmdLineException(e);
        }
        return statuses.toArray(new CmdLineStatusFromXml[statuses.size()]);
    }
}

