/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.ImportedFunctionLibrary;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.UnboundFunctionLibrary;
import net.sf.saxon.query.UndeclaredVariable;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;

public class StaticQueryContext
implements StaticContext {
    private boolean isMainModule;
    private Configuration config;
    private NamePool namePool;
    private String locationURI;
    private String moduleNamespace;
    private String baseURI;
    private HashMap passiveNamespaces;
    private HashSet explicitPrologNamespaces;
    private Stack activeNamespaces;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private NamespaceResolver externalNamespaceResolver = null;
    private CollationMap collations;
    private IntHashMap variables;
    private IntHashMap libraryVariables;
    private IntHashMap undeclaredVariables;
    private HashSet importedSchemata;
    private String defaultFunctionNamespace;
    private String defaultElementNamespace;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private SlotManager stackFrameMap;
    private short moduleNamespaceURICode;
    private ModuleURIResolver moduleURIResolver;
    private int constructionMode;
    private Executable executable;
    private List importers;
    private FunctionLibraryList functionLibraryList;
    private XQueryFunctionLibrary globalFunctionLibrary;
    private int localFunctionLibraryNr;
    private int importedFunctionLibraryNr;
    private int unboundFunctionLibraryNr;
    private Set importedModuleNamespaces;
    private ErrorListener errorListener;

    private StaticQueryContext() {
    }

    public StaticQueryContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.errorListener = configuration.getErrorListener();
        this.moduleURIResolver = configuration.getModuleURIResolver();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.isMainModule = true;
        this.collations = new CollationMap(configuration);
        this.reset();
    }

    public StaticQueryContext(Configuration configuration, StaticQueryContext staticQueryContext) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.isMainModule = false;
        if (this.importers == null && staticQueryContext != null) {
            this.importers = new ArrayList(2);
            this.importers.add(staticQueryContext);
        }
        this.reset();
    }

    public void reset() {
        this.passiveNamespaces = new HashMap(10);
        this.explicitPrologNamespaces = new HashSet(10);
        this.activeNamespaces = new Stack();
        this.externalNamespaceResolver = null;
        this.collations = new CollationMap(this.config);
        this.variables = new IntHashMap(10);
        this.undeclaredVariables = new IntHashMap(5);
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        if (this.isTopLevelModule()) {
            this.libraryVariables = new IntHashMap(10);
        }
        this.requiredContextItemType = AnyItemType.getInstance();
        this.importedSchemata = new HashSet(5);
        this.importedModuleNamespaces = new HashSet(5);
        this.defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
        this.defaultElementNamespace = "";
        this.moduleNamespace = null;
        this.moduleNamespaceURICode = 0;
        this.moduleURIResolver = this.config.getModuleURIResolver();
        this.constructionMode = this.config.isSchemaAware(51) ? 3 : 4;
        this.collations.setDefaultCollationName("http://www.w3.org/2005/xpath-functions/collation/codepoint");
        this.resetFunctionLibraries();
        this.clearPassiveNamespaces();
    }

    private void resetFunctionLibraries() {
        if (this.isTopLevelModule()) {
            this.globalFunctionLibrary = new XQueryFunctionLibrary(this.config);
        }
        this.functionLibraryList = new FunctionLibraryList();
        this.functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(0));
        this.functionLibraryList.addFunctionLibrary(this.config.getVendorFunctionLibrary());
        this.functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.config));
        if (this.config.isAllowExternalFunctions()) {
            Configuration.getPlatform().addFunctionLibraries(this.functionLibraryList, this.config);
        }
        this.localFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new XQueryFunctionLibrary(this.config));
        this.importedFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new ImportedFunctionLibrary(this, this.getTopLevelModule(this).getGlobalFunctionLibrary()));
        this.unboundFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new UnboundFunctionLibrary());
    }

    public boolean isTopLevelModule() {
        return this.importers == null;
    }

    public boolean isMainModule() {
        return this.isMainModule;
    }

    public boolean mayImport(String string) {
        if (string.equals(this.moduleNamespace)) {
            return false;
        }
        if (this.importers == null) {
            return true;
        }
        for (int i = 0; i < this.importers.size(); ++i) {
            if (((StaticQueryContext)this.importers.get(i)).mayImport(string)) continue;
            return false;
        }
        return true;
    }

    public XQueryFunctionLibrary getGlobalFunctionLibrary() {
        return this.globalFunctionLibrary;
    }

    public ImportedFunctionLibrary getImportedFunctionLibrary() {
        return (ImportedFunctionLibrary)this.functionLibraryList.get(this.importedFunctionLibraryNr);
    }

    public void addImportedNamespace(String string) {
        if (this.importedModuleNamespaces == null) {
            this.importedModuleNamespaces = new HashSet(5);
        }
        this.importedModuleNamespaces.add(string);
        this.getImportedFunctionLibrary().addImportedNamespace(string);
    }

    public boolean importsNamespace(String string) {
        return this.importedModuleNamespaces != null && this.importedModuleNamespaces.contains(string);
    }

    public boolean importsNamespaceIndirectly(String string) {
        if (this.importsNamespace(string)) {
            return true;
        }
        Iterator iterator = this.iterateImportedNamespaces();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            List list = this.executable.getQueryLibraryModules(string2);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                StaticQueryContext staticQueryContext = (StaticQueryContext)iterator2.next();
                if (!staticQueryContext.importsNamespaceIndirectly(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator iterateImportedNamespaces() {
        if (this.importedModuleNamespaces == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.importedModuleNamespaces.iterator();
    }

    public StaticQueryContext getTopLevelModule(StaticQueryContext staticQueryContext) {
        if (this.importers == null) {
            return this;
        }
        for (int i = 0; i < this.importers.size(); ++i) {
            StaticQueryContext staticQueryContext2 = (StaticQueryContext)this.importers.get(i);
            if (staticQueryContext.importsNamespace(staticQueryContext2.getModuleNamespace())) continue;
            return staticQueryContext2.getTopLevelModule(staticQueryContext);
        }
        return ((StaticQueryContext)this.importers.get(0)).getTopLevelModule(staticQueryContext);
    }

    public StaticQueryContext copy() {
        StaticQueryContext staticQueryContext = new StaticQueryContext();
        staticQueryContext.config = this.config;
        staticQueryContext.namePool = this.namePool;
        staticQueryContext.isMainModule = this.isMainModule;
        staticQueryContext.passiveNamespaces = new HashMap(this.passiveNamespaces);
        staticQueryContext.explicitPrologNamespaces = new HashSet(this.explicitPrologNamespaces);
        staticQueryContext.activeNamespaces = new Stack();
        staticQueryContext.externalNamespaceResolver = this.externalNamespaceResolver;
        staticQueryContext.inheritNamespaces = this.inheritNamespaces;
        staticQueryContext.preserveNamespaces = this.preserveNamespaces;
        staticQueryContext.collations = new CollationMap(this.collations);
        staticQueryContext.variables = this.variables.copy();
        staticQueryContext.undeclaredVariables = this.undeclaredVariables.copy();
        if (this.libraryVariables != null) {
            staticQueryContext.libraryVariables = this.libraryVariables.copy();
        }
        staticQueryContext.importedSchemata = new HashSet(this.importedSchemata);
        staticQueryContext.defaultFunctionNamespace = this.defaultFunctionNamespace;
        staticQueryContext.defaultElementNamespace = this.defaultElementNamespace;
        staticQueryContext.locationURI = this.locationURI;
        staticQueryContext.baseURI = this.baseURI;
        staticQueryContext.requiredContextItemType = this.requiredContextItemType;
        staticQueryContext.stackFrameMap = this.stackFrameMap;
        staticQueryContext.moduleNamespace = this.moduleNamespace;
        staticQueryContext.moduleNamespaceURICode = this.moduleNamespaceURICode;
        staticQueryContext.moduleURIResolver = this.moduleURIResolver;
        staticQueryContext.constructionMode = this.constructionMode;
        staticQueryContext.executable = this.executable;
        staticQueryContext.importers = this.importers;
        staticQueryContext.resetFunctionLibraries();
        return staticQueryContext;
    }

    public void setConfiguration(Configuration configuration) {
        if (this.config != configuration) {
            throw new IllegalArgumentException("Configuration cannot be changed dynamically");
        }
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.config, this.collations);
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        return this.config.buildDocument(source);
    }

    public XQueryExpression compileQuery(String string) throws XPathException {
        QueryParser queryParser = new QueryParser();
        queryParser.setCompileWithTracing(this.config.isCompileWithTracing());
        XQueryExpression xQueryExpression = queryParser.makeXQueryExpression(string, this.copy(), this.config);
        return xQueryExpression;
    }

    public XQueryExpression compileQuery(Reader reader) throws XPathException, IOException {
        int n;
        char[] cArray = new char[4096];
        StringBuffer stringBuffer = new StringBuffer(4096);
        while ((n = reader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return this.compileQuery(stringBuffer.toString());
    }

    public XQueryExpression compileQuery(InputStream inputStream, String string) throws XPathException, IOException {
        String string2 = QueryReader.readInputStream(inputStream, string, this.config.getNameChecker());
        return this.compileQuery(string2);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public LocationMap getLocationMap() {
        return this.executable.getLocationMap();
    }

    public void declarePassiveNamespace(String string, String string2, boolean bl) throws StaticError {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declarePassiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePassiveNamespace()");
        }
        if (string.equals("xml") != string2.equals("http://www.w3.org/XML/1998/namespace")) {
            StaticError staticError = new StaticError("Invalid declaration of the XML namespace");
            staticError.setErrorCode("XQST0070");
            throw staticError;
        }
        if (bl) {
            if (this.explicitPrologNamespaces.contains(string)) {
                StaticError staticError = new StaticError("Duplicate declaration of namespace prefix \"" + string + '\"');
                staticError.setErrorCode("XQST0033");
                throw staticError;
            }
            this.explicitPrologNamespaces.add(string);
        }
        if (string2.equals("") && !string.equals("")) {
            this.passiveNamespaces.remove(string);
        } else {
            this.passiveNamespaces.put(string, string2);
            this.namePool.allocateNamespaceCode(string, string2);
        }
    }

    public void declareActiveNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        int n = this.namePool.allocateNamespaceCode(string, string2);
        ActiveNamespace activeNamespace = new ActiveNamespace();
        activeNamespace.prefix = string;
        activeNamespace.uri = string2;
        activeNamespace.code = n;
        this.activeNamespaces.push(activeNamespace);
        if (string.equals("")) {
            this.defaultElementNamespace = string2;
        }
    }

    public void undeclareNamespace() {
        ActiveNamespace activeNamespace = (ActiveNamespace)this.activeNamespaces.pop();
        if (activeNamespace.prefix.equals("")) {
            for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
                if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals("")) continue;
                this.defaultElementNamespace = ((ActiveNamespace)this.activeNamespaces.get((int)i)).uri;
                return;
            }
            String string = (String)this.passiveNamespaces.get("");
            this.defaultElementNamespace = "".equals(string) ? "" : string;
        }
    }

    public void clearPassiveNamespaces() {
        try {
            if (this.passiveNamespaces != null) {
                this.passiveNamespaces.clear();
                this.declarePassiveNamespace("xml", "http://www.w3.org/XML/1998/namespace", false);
                this.declarePassiveNamespace("saxon", "http://saxon.sf.net/", false);
                this.declarePassiveNamespace("xs", "http://www.w3.org/2001/XMLSchema", false);
                this.declarePassiveNamespace("fn", "http://www.w3.org/2005/xpath-functions", false);
                this.declarePassiveNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance", false);
                this.declarePassiveNamespace("local", "http://www.w3.org/2005/xquery-local-functions", false);
                this.declarePassiveNamespace("", "", false);
            }
        }
        catch (StaticError staticError) {
            throw new IllegalStateException("Internal Failure initializing namespace declarations");
        }
    }

    public void setExternalNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.externalNamespaceResolver = namespaceResolver;
    }

    public NamespaceResolver getExternalNamespaceResolver() {
        return this.externalNamespaceResolver;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.checkURIForPrefix(string);
        if (string2 == null) {
            StaticError staticError = new StaticError("Prefix " + string + " has not been declared");
            staticError.setErrorCode("XPST0081");
            throw staticError;
        }
        return string2;
    }

    public String checkURIForPrefix(String string) {
        for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
            if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals(string)) continue;
            return ((ActiveNamespace)this.activeNamespaces.get((int)i)).uri;
        }
        String string2 = (String)this.passiveNamespaces.get(string);
        if (string2 != null) {
            return string2;
        }
        if (this.externalNamespaceResolver != null) {
            return this.externalNamespaceResolver.getURIForPrefix(string, true);
        }
        return null;
    }

    public int[] getActiveNamespaceCodes() {
        int[] nArray = new int[this.activeNamespaces.size()];
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>(10);
        for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
            ActiveNamespace activeNamespace = (ActiveNamespace)this.activeNamespaces.get(i);
            if (hashSet.contains(activeNamespace.prefix)) continue;
            hashSet.add(activeNamespace.prefix);
            nArray[n++] = activeNamespace.code;
        }
        if (n < nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public NamespaceResolver getNamespaceResolver() {
        int[] nArray = this.getActiveNamespaceCodes();
        int[] nArray2 = new int[this.passiveNamespaces.size() + nArray.length];
        int n = 0;
        Iterator iterator = this.passiveNamespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.passiveNamespaces.get(string);
            nArray2[n++] = this.namePool.getNamespaceCode(string, string2);
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n++] = nArray[i];
        }
        return new SavedNamespaceContext(nArray2, this.namePool);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    public void setDefaultElementNamespace(String string) throws StaticError {
        this.defaultElementNamespace = string;
        this.declarePassiveNamespace("", string, true);
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setModuleNamespace(String string) {
        this.moduleNamespace = string;
        this.moduleNamespaceURICode = this.namePool.getCodeForURI(string);
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public short getModuleNamespaceCode() {
        return this.moduleNamespaceURICode;
    }

    public void setLocationURI(String string) {
        this.locationURI = string;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void setInheritNamespaces(boolean bl) {
        this.inheritNamespaces = bl;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean bl) {
        this.preserveNamespaces = bl;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void declareCollation(String string, Comparator comparator) {
        this.declareCollation(string, new NamedCollation(string, comparator));
    }

    public void declareCollation(String string, StringCollator stringCollator) {
        this.collations.setNamedCollation(string, stringCollator);
    }

    public void declareDefaultCollation(String string) {
        this.collations.setDefaultCollationName(string);
    }

    public StringCollator getCollation(String string) {
        return this.collations.getNamedCollation(string);
    }

    public String getDefaultCollationName() {
        return this.collations.getDefaultCollationName();
    }

    public CollationMap getAllCollations() {
        return new CollationMap(this.collations);
    }

    public void setRequiredContextItemType(ItemType itemType) {
        this.requiredContextItemType = itemType;
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public SlotManager getGlobalStackFrameMap() {
        return this.executable.getGlobalVariableMap();
    }

    public void declareVariable(VariableDeclaration variableDeclaration) throws StaticError {
        Object object;
        int n = variableDeclaration.getNameCode() & 0xFFFFF;
        if (this.variables.get(n) != null && (object = (GlobalVariableDefinition)this.variables.get(n)) != variableDeclaration) {
            StaticError staticError = new StaticError("Duplicate definition of global variable " + variableDeclaration.getVariableName() + " (see line " + ((GlobalVariableDefinition)object).getLineNumber() + ')');
            staticError.setErrorCode("XQST0049");
            if (variableDeclaration instanceof GlobalVariableDefinition) {
                ExpressionLocation expressionLocation = new ExpressionLocation();
                expressionLocation.setLineNumber(((GlobalVariableDefinition)variableDeclaration).getLineNumber());
                expressionLocation.setSystemId(((GlobalVariableDefinition)variableDeclaration).getSystemId());
                staticError.setLocator(expressionLocation);
            }
            throw staticError;
        }
        this.variables.put(n, variableDeclaration);
        object = this.getTopLevelModule((StaticQueryContext)this).libraryVariables;
        GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)((IntHashMap)object).get(n);
        if (globalVariableDefinition != null && globalVariableDefinition != variableDeclaration) {
            StaticError staticError = new StaticError("Duplicate definition of global variable " + variableDeclaration.getVariableName() + " (see line " + globalVariableDefinition.getLineNumber() + " in module " + globalVariableDefinition.getSystemId() + ')');
            staticError.setErrorCode("XQST0049");
            if (variableDeclaration instanceof GlobalVariableDefinition) {
                ExpressionLocation expressionLocation = new ExpressionLocation();
                expressionLocation.setLineNumber(((GlobalVariableDefinition)variableDeclaration).getLineNumber());
                expressionLocation.setSystemId(((GlobalVariableDefinition)variableDeclaration).getSystemId());
                staticError.setLocator(expressionLocation);
            }
            throw staticError;
        }
        if (!this.isTopLevelModule()) {
            ((IntHashMap)object).put(n, variableDeclaration);
        }
    }

    public List fixupGlobalVariables(SlotManager slotManager) throws StaticError {
        ArrayList<GlobalVariable> arrayList = new ArrayList<GlobalVariable>(20);
        Iterator[] iteratorArray = new Iterator[]{this.variables.valueIterator(), this.libraryVariables.valueIterator()};
        for (int i = 0; i < 2; ++i) {
            while (iteratorArray[i].hasNext()) {
                GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)iteratorArray[i].next();
                try {
                    int n = slotManager.allocateSlotNumber(globalVariableDefinition.getNameCode() & 0xFFFFF);
                    GlobalVariable globalVariable = globalVariableDefinition.getCompiledVariable();
                    if (globalVariable == null) {
                        globalVariable = globalVariableDefinition.compile(this, n);
                    }
                    if (arrayList.contains(globalVariable)) continue;
                    arrayList.add(globalVariable);
                }
                catch (XPathException xPathException) {
                    throw StaticError.makeStaticError(xPathException);
                }
            }
        }
        return arrayList;
    }

    public void lookForModuleCycles(Stack stack, int n) throws XPathException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        if (stack.contains(this)) {
            Object object5;
            int n2 = stack.indexOf(this);
            stack.push(this);
            String string = "Circular dependency between modules. ";
            for (int i = n2; i < stack.size() - 1; ++i) {
                object5 = (StaticQueryContext)stack.get(i + 1);
                string = i == n2 ? string + "Module " + this.getSystemId() + " references module " + ((StaticQueryContext)object5).getSystemId() : string + ", which references module " + ((StaticQueryContext)object5).getSystemId();
            }
            string = string + '.';
            StaticError staticError = new StaticError(string);
            staticError.setErrorCode("XQST0093");
            object5 = new ExpressionLocation();
            ((ExpressionLocation)object5).setSystemId(this.getSystemId());
            ((ExpressionLocation)object5).setLineNumber(n);
            staticError.setLocator((SourceLocator)object5);
            throw staticError;
        }
        stack.push(this);
        Iterator iterator = this.getModuleVariables();
        while (iterator.hasNext()) {
            Object object6;
            int n3;
            object4 = (GlobalVariableDefinition)iterator.next();
            object3 = new ArrayList(10);
            serializable = ((GlobalVariableDefinition)object4).getCompiledVariable().getSelectExpression();
            if (serializable == null) continue;
            ExpressionTool.gatherReferencedVariables((Expression)serializable, (List)object3);
            for (n3 = 0; n3 < object3.size(); ++n3) {
                object6 = (Binding)object3.get(n3);
                if (!(object6 instanceof GlobalVariable) || ((String)(object2 = ((GlobalVariable)object6).getSystemId())).equals(this.getSystemId())) continue;
                object = this.executable.getQueryModuleWithSystemId((String)object2);
                ((StaticQueryContext)object).lookForModuleCycles(stack, ((GlobalVariable)object6).getLineNumber());
            }
            object3.clear();
            ExpressionTool.gatherCalledFunctions((Expression)serializable, (List)object3);
            for (n3 = 0; n3 < object3.size(); ++n3) {
                object6 = (UserFunction)object3.get(n3);
                object2 = ((Procedure)object6).getSystemId();
                if (((String)object2).equals(this.getSystemId())) continue;
                object = this.executable.getQueryModuleWithSystemId((String)object2);
                ((StaticQueryContext)object).lookForModuleCycles(stack, ((Procedure)object6).getLineNumber());
            }
        }
        object4 = this.getLocalFunctionLibrary().getFunctionDefinitions();
        while (object4.hasNext()) {
            StaticQueryContext staticQueryContext;
            int n4;
            object3 = (XQueryFunction)object4.next();
            serializable = new ArrayList(10);
            Expression expression = ((XQueryFunction)object3).getUserFunction().getBody();
            if (expression == null) continue;
            ExpressionTool.gatherReferencedVariables(expression, (List)((Object)serializable));
            for (n4 = 0; n4 < serializable.size(); ++n4) {
                object2 = (Binding)serializable.get(n4);
                if (!(object2 instanceof GlobalVariable) || ((String)(object = ((GlobalVariable)object2).getSystemId())).equals(this.getSystemId())) continue;
                staticQueryContext = this.executable.getQueryModuleWithSystemId((String)object);
                staticQueryContext.lookForModuleCycles(stack, ((GlobalVariable)object2).getLineNumber());
            }
            serializable.clear();
            ExpressionTool.gatherCalledFunctions(expression, (List)((Object)serializable));
            for (n4 = 0; n4 < serializable.size(); ++n4) {
                object2 = (UserFunction)serializable.get(n4);
                object = ((Procedure)object2).getSystemId();
                if (((String)object).equals(this.getSystemId())) continue;
                staticQueryContext = this.executable.getQueryModuleWithSystemId((String)object);
                staticQueryContext.lookForModuleCycles(stack, ((Procedure)object2).getLineNumber());
            }
        }
        stack.pop();
    }

    public Iterator getModuleVariables() {
        return this.variables.valueIterator();
    }

    public void typeCheckGlobalVariables(List list) throws StaticError {
        try {
            Iterator iterator = list.iterator();
            Stack stack = new Stack();
            while (iterator.hasNext()) {
                GlobalVariable globalVariable = (GlobalVariable)iterator.next();
                globalVariable.lookForCycles(stack);
                GlobalVariableDefinition.typeCheck(this, globalVariable);
            }
        }
        catch (XPathException xPathException) {
            throw StaticError.makeStaticError(xPathException);
        }
    }

    public void explainGlobalVariables(PrintStream printStream) {
        Iterator iterator = this.variables.valueIterator();
        while (iterator.hasNext()) {
            GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)iterator.next();
            globalVariableDefinition.explain(this.getConfiguration(), printStream);
        }
    }

    public SlotManager getStackFrameMap() {
        if (this.stackFrameMap == null) {
            this.stackFrameMap = this.getConfiguration().makeSlotManager();
        }
        return this.stackFrameMap;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        StaticError staticError = new StaticError(string);
        staticError.setLocator(sourceLocator);
        try {
            this.config.getErrorListener().warning(staticError);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public VariableReference bindVariable(int n) throws StaticError {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.variables.get(n);
        if (variableDeclaration == null) {
            String string = this.getNamePool().getURI(n);
            if (this.importedModuleNamespaces.contains(string)) {
                StaticQueryContext staticQueryContext = this.getTopLevelModule(this);
                variableDeclaration = (VariableDeclaration)staticQueryContext.libraryVariables.get(n);
                if (variableDeclaration == null) {
                    UndeclaredVariable undeclaredVariable = new UndeclaredVariable();
                    undeclaredVariable.setNameCode(n);
                    undeclaredVariable.setVariableName(this.getNamePool().getDisplayName(n));
                    VariableReference variableReference = new VariableReference(undeclaredVariable);
                    this.undeclaredVariables.put(n, undeclaredVariable);
                    return variableReference;
                }
                GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)variableDeclaration;
                this.checkImportedType(globalVariableDefinition.getRequiredType(), globalVariableDefinition);
            } else {
                StaticError staticError = new StaticError("Unresolved reference to variable");
                staticError.setErrorCode("XPST0008");
                throw staticError;
            }
        }
        return new VariableReference(variableDeclaration);
    }

    public void setFunctionLibraryList(FunctionLibraryList functionLibraryList) {
        this.functionLibraryList = functionLibraryList;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibraryList;
    }

    public XQueryFunctionLibrary getLocalFunctionLibrary() {
        return (XQueryFunctionLibrary)this.functionLibraryList.get(this.localFunctionLibraryNr);
    }

    public void declareFunction(XQueryFunction xQueryFunction) throws StaticError {
        Serializable serializable;
        if (xQueryFunction.getNumberOfArguments() == 1 && (serializable = this.config.getSchemaType(xQueryFunction.getNameCode() & 0xFFFFF)) != null && serializable.isAtomicType()) {
            StaticError staticError = new StaticError("Function name " + xQueryFunction.getFunctionDisplayName(this.getNamePool()) + " clashes with the name of the constructor function for an atomic type");
            staticError.setErrorCode("XQST0034");
            throw staticError;
        }
        serializable = this.getLocalFunctionLibrary();
        ((XQueryFunctionLibrary)serializable).declareFunction(xQueryFunction);
        StaticQueryContext staticQueryContext = this.getTopLevelModule(this);
        staticQueryContext.globalFunctionLibrary.declareFunction(xQueryFunction);
    }

    public void bindUnboundFunctionCalls() throws XPathException {
        UnboundFunctionLibrary unboundFunctionLibrary = (UnboundFunctionLibrary)this.functionLibraryList.get(this.unboundFunctionLibraryNr);
        unboundFunctionLibrary.bindUnboundFunctionCalls(this.functionLibraryList, this.config);
    }

    public void fixupGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.fixupGlobalFunctions(this);
    }

    public void explainGlobalFunctions(PrintStream printStream) throws XPathException {
        this.globalFunctionLibrary.explainGlobalFunctions(printStream);
    }

    public UserFunction getUserDefinedFunction(String string, String string2, int n) {
        return this.globalFunctionLibrary.getUserDefinedFunction(string, string2, n);
    }

    public void bindUnboundVariables() throws XPathException {
        Iterator iterator = this.undeclaredVariables.valueIterator();
        while (iterator.hasNext()) {
            Object object;
            UndeclaredVariable undeclaredVariable = (UndeclaredVariable)iterator.next();
            int n = undeclaredVariable.getNameCode() & 0xFFFFF;
            VariableDeclaration variableDeclaration = (VariableDeclaration)this.variables.get(n);
            if (variableDeclaration == null && this.importedModuleNamespaces.contains(object = this.getNamePool().getURI(n))) {
                StaticQueryContext staticQueryContext = this.getTopLevelModule(this);
                variableDeclaration = (VariableDeclaration)staticQueryContext.libraryVariables.get(n);
            }
            if (variableDeclaration == null) {
                object = new StaticError("Unresolved reference to variable $" + undeclaredVariable.getVariableName());
                ((XPathException)object).setErrorCode("XPST0008");
                throw object;
            }
            object = (GlobalVariableDefinition)variableDeclaration;
            this.checkImportedType(((GlobalVariableDefinition)object).getRequiredType(), (Declaration)object);
            undeclaredVariable.transferReferences(variableDeclaration);
        }
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public void addImportedSchema(String string) {
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet(5);
        }
        this.importedSchemata.add(string);
    }

    public boolean isImportedSchema(String string) {
        if (this.importedSchemata == null) {
            return false;
        }
        return this.importedSchemata.contains(string);
    }

    public Set getImportedSchemaNamespaces() {
        return this.importedSchemata;
    }

    public boolean isAllowedBuiltInType(AtomicType atomicType) {
        return true;
    }

    public void setConstructionMode(int n) {
        this.constructionMode = n;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public static StaticQueryContext makeStaticQueryContext(String string, Executable executable, StaticQueryContext staticQueryContext, String string2, String string3, boolean bl) throws StaticError {
        Configuration configuration = executable.getConfiguration();
        StaticQueryContext staticQueryContext2 = new StaticQueryContext(configuration, staticQueryContext);
        staticQueryContext2.setLocationURI(string);
        staticQueryContext2.setBaseURI(string);
        staticQueryContext2.setModuleNamespace(string3);
        staticQueryContext2.setExecutable(executable);
        if (staticQueryContext != null) {
            staticQueryContext2.setModuleURIResolver(staticQueryContext.getModuleURIResolver());
        }
        executable.addQueryLibraryModule(staticQueryContext2);
        QueryParser queryParser = new QueryParser();
        queryParser.setCompileWithTracing(configuration.isCompileWithTracing());
        queryParser.setDisableCycleChecks(bl);
        queryParser.parseLibraryModule(string2, staticQueryContext2);
        if (staticQueryContext2.getModuleNamespace() == null) {
            StaticError staticError = new StaticError("Imported module must be a library module");
            staticError.setErrorCode("XQST0059");
            throw staticError;
        }
        if (!staticQueryContext2.getModuleNamespace().equals(string3)) {
            StaticError staticError = new StaticError("Imported module's namespace does not match requested namespace");
            staticError.setErrorCode("XQST0059");
            throw staticError;
        }
        return staticQueryContext2;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        if (this.errorListener == null) {
            this.errorListener = this.config.getErrorListener();
        }
        return this.errorListener;
    }

    public void reportFatalError(XPathException xPathException) {
        if (!xPathException.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            xPathException.setHasBeenReported();
        }
    }

    public void checkImportedType(SequenceType sequenceType, Declaration declaration) throws StaticError {
        ItemType itemType = sequenceType.getPrimaryType();
        if (itemType instanceof AnyItemType) {
            return;
        }
        if (itemType.isAtomicType()) {
            int n = ((AtomicType)itemType).getFingerprint();
            QueryReader.checkSchemaNamespaceImported(this, n, declaration);
        } else if (itemType instanceof ContentTypeTest) {
            SchemaType schemaType = ((ContentTypeTest)itemType).getSchemaType();
            int n = schemaType.getFingerprint();
            QueryReader.checkSchemaNamespaceImported(this, n, declaration);
        } else if (itemType instanceof CombinedNodeTest) {
            NodeTest[] nodeTestArray = ((CombinedNodeTest)itemType).getComponentNodeTests();
            for (int i = 0; i < nodeTestArray.length; ++i) {
                SequenceType sequenceType2 = SequenceType.makeSequenceType(nodeTestArray[i], 16384);
                this.checkImportedType(sequenceType2, declaration);
            }
        }
    }

    private static class ActiveNamespace {
        public String prefix;
        public String uri;
        public int code;

        private ActiveNamespace() {
        }
    }
}

