/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.chaperon.ant.AntLog;
import net.sourceforge.chaperon.build.LexicalAutomatonBuilder;
import net.sourceforge.chaperon.build.ParserAutomatonBuilder;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.grammar.GrammarFactory;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.model.lexicon.LexiconFactory;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.LexicalProcessor;
import net.sourceforge.chaperon.process.ParserAutomaton;
import net.sourceforge.chaperon.process.ParserProcessor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.IdentityMapper;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class ParserTask
extends MatchingTask {
    private File srcDir = null;
    private File destDir = null;
    private File baseDir = null;
    private File cacheDir = null;
    private Mapper mapper = null;
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private File lexiconFile = null;
    private File grammarFile = null;
    private String parserFactory = null;
    private SAXParserFactory parserFactoryImpl = null;
    private String transformerFactory = null;
    private SAXTransformerFactory transformerFactoryImpl = null;
    private String encoding = "ISO-8859-1";
    private boolean indent = false;
    private boolean flatten = false;
    private String inputtype = "text";
    private int msgLevel = 0;
    private AntLog log;
    private ParserAutomaton parserautomaton = null;
    private ParserProcessor parser = null;
    private LexicalAutomaton lexicalautomaton = null;
    private LexicalProcessor lexer = null;
    private static final String NL = System.getProperty("line.separator");
    private static final char[] initNonXmlChars = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private char[] nonXmlChars = initNonXmlChars;

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            this.baseDir = this.project.resolveFile(".");
        }
        if (this.lexiconFile == null) {
            throw new BuildException("No lexicon file is specified", this.location);
        }
        if (!this.lexiconFile.exists()) {
            throw new BuildException("Lexicon file doesn't exists:" + this.lexiconFile.getAbsolutePath(), this.location);
        }
        if (this.destDir == null) {
            throw new BuildException("No destdir specified!", this.location);
        }
        this.log = new AntLog(this.getProject(), this.msgLevel);
        this.buildAutomata(this.lexiconFile, this.grammarFile);
        DirectoryScanner scanner = this.getDirectoryScanner(this.srcDir);
        Object mapperImpl = this.mapper == null ? new IdentityMapper() : this.mapper.getImplementation();
        String[] list = scanner.getIncludedFiles();
        int i = 0;
        while (i < list.length) {
            String[] dest = mapperImpl.mapFileName(list[i]);
            if (dest != null) {
                int j = 0;
                while (j < dest.length) {
                    this.log("Transforming " + list[i] + " to " + dest[j], 4);
                    this.process(new File(this.srcDir, list[i]), new File(this.destDir, dest[j]));
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setSrcdir(File dir) {
        this.srcDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setCachedir(File dir) {
        this.cacheDir = dir;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapper = new Mapper(this.project);
        return this.mapper;
    }

    public void setLexicon(File lexiconFile) {
        this.lexiconFile = lexiconFile;
    }

    public void setGrammar(File grammarFile) {
        this.grammarFile = grammarFile;
    }

    public void setMsglevel(String msgLevel) {
        if (msgLevel.equalsIgnoreCase("debug")) {
            this.msgLevel = 4;
        } else if (msgLevel.equalsIgnoreCase("verbose")) {
            this.msgLevel = 3;
        } else if (msgLevel.equalsIgnoreCase("info")) {
            this.msgLevel = 2;
        } else if (msgLevel.equalsIgnoreCase("warn")) {
            this.msgLevel = 1;
        } else if (msgLevel.equalsIgnoreCase("error")) {
            this.msgLevel = 0;
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setInputtype(String inputtype) {
        this.inputtype = inputtype;
    }

    public void setParser(String parserFactory) {
        this.parserFactory = parserFactory;
    }

    public void setTransformer(String transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public void setNonXmlChars(String nonXmlChars) {
        this.nonXmlChars = nonXmlChars.toCharArray();
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.project);
    }

    private void process(File inFile, File outFile) throws BuildException {
        try {
            if (this.nonXmlChars.length != initNonXmlChars.length) {
                throw new BuildException("nonXmlChars-attribute should have exactly " + initNonXmlChars.length + " characters, where '" + String.valueOf(this.nonXmlChars) + "' has " + this.nonXmlChars.length + " characters");
            }
            if (!inFile.exists()) {
                throw new BuildException("File " + inFile + " doesn't exists", this.location);
            }
            if (inFile.lastModified() > outFile.lastModified() || this.lexiconFile.lastModified() > outFile.lastModified() || this.grammarFile != null && this.grammarFile.lastModified() > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Parsing file " + inFile + " to " + outFile, 2);
                Properties format = new Properties();
                format.put("encoding", "ASCII");
                if (this.indent) {
                    format.put("indent", "yes");
                }
                format.put("method", "xml");
                SAXTransformerFactory factory = this.getTransformerFactory();
                TransformerHandler serializer = factory.newTransformerHandler();
                serializer.getTransformer().setOutputProperties(format);
                serializer.setResult(new StreamResult(outFile));
                if (this.parserautomaton != null) {
                    this.parser = new ParserProcessor();
                    this.parser.setLog(this.log);
                    this.parser.setFlatten(this.flatten);
                    this.parser.setParserAutomaton(this.parserautomaton);
                    this.parser.setContentHandler(serializer);
                }
                this.lexer = new LexicalProcessor();
                this.lexer.setLog(this.log);
                this.lexer.setLexicalAutomaton(this.lexicalautomaton);
                if (this.parserautomaton != null) {
                    this.lexer.setContentHandler(this.parser);
                } else {
                    this.lexer.setContentHandler(serializer);
                }
                if (!this.inputtype.equalsIgnoreCase("xml")) {
                    this.pushTextFile(inFile);
                } else {
                    this.pushXMLFile(inFile);
                }
            }
        }
        catch (Exception ex) {
            if (outFile != null) {
                outFile.delete();
            }
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Failed to process " + inFile + " : " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void buildAutomata(File lexiconFile, File grammarFile) throws BuildException {
        block15: {
            if (this.cacheDir != null && !this.cacheDir.exists()) {
                throw new BuildException("Cache directory " + this.cacheDir + " doesn't exist");
            }
            try {
                ObjectOutputStream out;
                XMLReader parser;
                SAXParserFactory factory;
                ObjectInputStream in;
                String filename = lexiconFile.getName();
                File cacheFile = null;
                if (this.cacheDir != null) {
                    cacheFile = new File(this.cacheDir, filename + ".obj");
                }
                if (cacheFile != null && cacheFile.exists() && cacheFile.lastModified() > lexiconFile.lastModified()) {
                    this.log("Reading lexicon from cache " + cacheFile, 4);
                    in = new ObjectInputStream(new FileInputStream(cacheFile));
                    this.lexicalautomaton = (LexicalAutomaton)in.readObject();
                    in.close();
                } else {
                    this.log("Building lexicon from " + lexiconFile, 2);
                    factory = this.getParserFactory();
                    factory.setNamespaceAware(true);
                    parser = factory.newSAXParser().getXMLReader();
                    parser.setEntityResolver((EntityResolver)this.xmlCatalog);
                    LexiconFactory lexiconfactory = new LexiconFactory();
                    parser.setContentHandler(lexiconfactory);
                    try {
                        parser.parse(lexiconFile.toString());
                    }
                    catch (SAXParseException se) {
                        throw new BuildException("Couldn't parse file " + lexiconFile, (Throwable)se);
                    }
                    Lexicon lexicon = lexiconfactory.getLexicon();
                    this.lexicalautomaton = new LexicalAutomatonBuilder(lexicon, this.log).getLexicalAutomaton();
                    if (cacheFile != null) {
                        out = new ObjectOutputStream(new FileOutputStream(cacheFile));
                        out.writeObject(this.lexicalautomaton);
                        out.flush();
                        out.close();
                    }
                }
                if (grammarFile == null) break block15;
                filename = grammarFile.getName();
                cacheFile = null;
                if (this.cacheDir != null) {
                    cacheFile = new File(this.cacheDir, filename + ".obj");
                }
                if (cacheFile != null && cacheFile.exists() && cacheFile.lastModified() > grammarFile.lastModified()) {
                    this.log("Reading grammar from cache " + cacheFile, 4);
                    in = new ObjectInputStream(new FileInputStream(cacheFile));
                    this.parserautomaton = (ParserAutomaton)in.readObject();
                    in.close();
                    break block15;
                }
                this.log("Building grammar from " + grammarFile, 2);
                factory = this.getParserFactory();
                factory.setNamespaceAware(true);
                parser = factory.newSAXParser().getXMLReader();
                parser.setEntityResolver((EntityResolver)this.xmlCatalog);
                GrammarFactory grammarfactory = new GrammarFactory();
                parser.setContentHandler(grammarfactory);
                try {
                    parser.parse(grammarFile.toString());
                }
                catch (SAXParseException se) {
                    throw new BuildException("Couldn't parse file " + lexiconFile, (Throwable)se);
                }
                Grammar grammar = grammarfactory.getGrammar();
                this.parserautomaton = new ParserAutomatonBuilder(grammar, this.log).getParserAutomaton();
                if (cacheFile != null) {
                    out = new ObjectOutputStream(new FileOutputStream(cacheFile));
                    out.writeObject(this.parserautomaton);
                    out.flush();
                    out.close();
                }
            }
            catch (Exception ex) {
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private void pushTextFile(File inFile) throws Exception {
        try {
            String line;
            LocatorImpl locator = new LocatorImpl();
            locator.setSystemId(inFile.toURL().toString());
            locator.setLineNumber(1);
            locator.setColumnNumber(1);
            this.lexer.setDocumentLocator(locator);
            this.lexer.startDocument();
            this.lexer.startElement("http://chaperon.sourceforge.net/schema/text/1.0", "text", "text", new AttributesImpl());
            LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(inFile), this.encoding));
            String newline = null;
            while ((line = newline == null ? this.convertNonXmlChars(reader.readLine()) : newline) != null) {
                newline = this.convertNonXmlChars(reader.readLine());
                line = newline != null ? line + NL : line;
                locator.setLineNumber(reader.getLineNumber());
                locator.setColumnNumber(1);
                this.lexer.characters(line.toCharArray(), 0, line.length());
                if (newline != null) continue;
            }
            reader.close();
            this.lexer.endElement("http://chaperon.sourceforge.net/schema/text/1.0", "text", "text");
            this.lexer.endDocument();
        }
        catch (SAXParseException se) {
            throw new BuildException("Exception occurs during parsing file " + inFile + " at line " + se.getLineNumber() + " column " + se.getColumnNumber(), (Throwable)se);
        }
    }

    private void pushXMLFile(File inFile) throws Exception {
        SAXParserFactory parserfactory = this.getParserFactory();
        parserfactory.setNamespaceAware(true);
        XMLReader parser = parserfactory.newSAXParser().getXMLReader();
        parser.setEntityResolver((EntityResolver)this.xmlCatalog);
        parser.setContentHandler(this.lexer);
        try {
            parser.parse(inFile.toString());
        }
        catch (SAXParseException se) {
            throw new BuildException("Exception occurs during parsing file " + inFile + " at line " + se.getLineNumber() + " column " + se.getColumnNumber(), (Throwable)se);
        }
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    private SAXParserFactory getParserFactory() throws BuildException {
        if (this.parserFactoryImpl == null) {
            try {
                this.parserFactoryImpl = this.parserFactory == null ? SAXParserFactory.newInstance() : (SAXParserFactory)Class.forName(this.parserFactory).newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Could not load parser factory", (Throwable)e);
            }
        }
        return this.parserFactoryImpl;
    }

    private SAXTransformerFactory getTransformerFactory() throws BuildException {
        if (this.transformerFactoryImpl == null) {
            try {
                this.transformerFactoryImpl = this.transformerFactory == null ? (SAXTransformerFactory)SAXTransformerFactory.newInstance() : (SAXTransformerFactory)Class.forName(this.transformerFactory).newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Could not load transformer factory", (Throwable)e);
            }
        }
        return this.transformerFactoryImpl;
    }

    private String convertNonXmlChars(String s) {
        if (s == null) {
            return null;
        }
        char[] sc = s.toCharArray();
        int i = 0;
        while (i < sc.length) {
            char nv = sc[i];
            if (nv >= '\u0000' && nv < this.nonXmlChars.length && nv != '\t' && nv != '\n' && nv != '\r') {
                sc[i] = this.nonXmlChars[nv];
            }
            ++i;
        }
        return String.valueOf(sc);
    }
}

